<?php

namespace Internetgalerie\IgMailMarkers\EventListener;

use MEDIAESSENZ\Mail\Events\ManipulateMarkersEvent;
use TYPO3\CMS\Core\Localization\LanguageService;
use TYPO3\CMS\Core\Utility\GeneralUtility;

abstract class AbstractMailMarkersEventListener
{
    protected ManipulateMarkersEvent $event;
    protected array $markers;
    protected array $recipient;
    protected array $possibleKeys;
    protected string $languageFile = 'LLL:EXT:ig_mail_markers/Resources/Private/Language/locallang.xlf';

    public function __invoke(ManipulateMarkersEvent $event): void
    {
        $this->event = $event;
        $this->markers = $event->getMarkers();
        $this->recipient = $event->getRecipient();
        if (empty($this->possibleKeys)) {
            throw new \InvalidArgumentException('$possibleKeys not set.');
        }
    }
    protected function setMarkers(string $value): static
    {
        foreach ($this->possibleKeys as $key) {
            $this->markers[$key] = $value;
        }
        $this->event->setMarkers($this->markers);
        return $this;
    }
    protected function getLanguageService(): LanguageService
    {
        return $GLOBALS['LANG'] ?? GeneralUtility::makeInstance(LanguageService::class);
    }
    protected function translate(string $key): string
    {
        return $this->getLanguageService()->sL($this->languageFile . ':' . $key) ?? '';
    }
}
