<?php

namespace Ig\IgMenu\Domain\Model;

use Ig\IgMenu\Utility\SettingsUtility;
use TYPO3\CMS\Core\Resource\FileRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManager;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;

/**
 * Page
 */
class MenuItem extends AbstractEntity
{
    //protected ?int $uid;
    protected $title = '';

    protected $link = '';

    protected $linkClass = '';

    protected $subtitle;

    protected $target = '';

    protected $navTitle;

    protected $activeKey = null;

    protected $data;

    protected $alias = null;

    // not used
    //protected ?int $pid;
    protected $doktype = null;

    protected $url;

    protected $_MP_PARAM;

    protected $shortcut;

    protected $mountPid;

    protected $mountPidOl;

    protected $ig_menu_icon;

    protected $ig_menu_icon_position;

    protected $ig_menu_content;

    protected $ig_menu_content_position;

    protected $ig_menu_columns;

    protected $ig_menu_is_menuroot;
    protected $ig_menu_hide_submenu;

    protected $pageOverlay = null;

    /**
     * igMenuLayout - the layout e.g. 2 cols
     *
     * @var integer
     */
    protected $igMenuLayout;

    /**
     * igMenuSource - the source of the data e.g. pages, provider for external DBs
     *
     * @var string
     */
    protected $igMenuSource = null;

    /**
     * igMenuSourceOptions - source options
     *
     * @var string
     */
    protected $igMenuSourceOptions;

    /**
     * igMenuColWidth
     *
     * @var integer
     */
    protected $igMenuColWidth;

    protected $igMenuLayoutCols;

    protected $igMenuReplacementText;

    protected $igMenuItemClass;

    protected $position;

    protected $settings;

    //protected $children;
    protected $content;

    protected $isRoot;

    public function load($page, $options = null)
    {
        $this->setData($page);
        $this->setUid($page['uid']);
        $this->setPid($page['pid']);
        $this->setTitle($page['title']);
        $this->setSubtitle($page['subtitle']);
        $this->setNavTitle($page['nav_title']);
        $this->setAlias($page['alias'] ?? '');
        $this->setDoktype($page['doktype']);
        $this->setUrl($page);
        $this->setShortcut($page['shortcut']);
        $this->setMountPid($page['mount_pid']);
        $this->setMountPidOl($page['mount_pid_ol']);
        $this->setTarget($page['target']);
        $this->set_MP_PARAM($page['_MP_PARAM'] ?? '');
        $this->setIg_menu_icon($page['ig_menu_icon']);
        $this->setIg_menu_icon_position($page['ig_menu_icon_position']);
        $this->setIg_menu_content($page['ig_menu_content']);
        $this->setIg_menu_content_position($page['ig_menu_content_position']);
        $this->setIgMenuSource($page['ig_menu_source']);
        $this->setIgMenuSourceOptions($page['ig_menu_source_options']);
        $this->setIgMenuLayout($page['ig_menu_layout']);
        $this->setIgMenuColWidth($page['ig_menu_col_width']);
        $this->setIgMenuReplacementText($page['ig_menu_replacement_text']);
        $this->setIgMenuLayoutCols($page['ig_menu_layout_cols']);
        $this->setIgMenuItemClass($page['ig_menu_item_class']);
        $this->setIgMenuColumns($page['ig_menu_columns']);
        $this->setIgMenuIsMenuroot($page['ig_menu_is_menuroot'] ?? false);
        $this->setIgMenuHideSubmenu($page['ig_menu_hide_submenu'] ?? false);

        if (is_array($options)) {
            $this->setPosition($options['position']);
            $this->setIsRoot($options['isRoot']);
        } else {
            $this->setPosition(0);
            $this->setIsRoot(0);
        }

        // Overvrite menu items from settings
        $menuConf = GeneralUtility::makeInstance(SettingsUtility::class);
        if ($config = $menuConf->getSettingsConfig()) {
            if (isset($config['igMenuLayout'])) {
                $this->setIgMenuLayout($config['igMenuLayout']);
            }
        }

        return $this;
    }

    // @todo Merge for Mount Points
    public function mergeIgMenuAttributes($page): void
    {
        $this->setIg_menu_icon($page['ig_menu_icon']);
        $this->setIg_menu_icon_position($page['ig_menu_icon_position']);
        $this->setIg_menu_content($page['ig_menu_content']);
        $this->setIg_menu_content_position($page['ig_menu_content_position']);
        $this->setIgMenuLayout($page['ig_menu_layout']);
        $this->setIgMenuColWidth($page['ig_menu_col_width']);
        $this->setIgMenuReplacementText($page['ig_menu_replacement_text']);
        $this->setIgMenuLayoutCols($page['ig_menu_layout_cols']);
        $this->setIgMenuItemClass($page['ig_menu_item_class']);
        $this->setIgMenuIsMenuroot($page['ig_menu_is_menuroot'] ?? false);
        $this->setIgMenuHideSubmenu($page['ig_menu_hide_submenu'] ?? false);
    }


    public function getUid(): ?int
    {
        return $this->uid;
    }

    public function setUid(int $uid): void
    {
        $this->uid = $uid;
    }

    public function getPid(): ?int
    {
        return $this->pid;
    }

    public function setPid(int $pid): void
    {
        $this->pid = $pid;
    }

    public function getTitle()
    {
        return $this->title;
    }

    public function setTitle($title): void
    {
        $this->title = $title;
    }

    public function getSubtitle()
    {
        return $this->subtitle;
    }

    public function setSubtitle($subtitle): void
    {
        $this->subtitle = $subtitle;
    }

    public function getLink(): string
    {
        return $this->link;
    }

    public function setLink(string $link): void
    {
        $this->link = $link;
    }

    public function getActiveKey(): string
    {
        return $this->activeKey;
    }

    public function setActiveKey(string $activeKey): void
    {
        $this->activeKey = $activeKey;
    }

    public function getData()
    {
        return $this->data;
    }

    public function setData($data): void
    {
        $this->data = $data;
    }

    public function getLinkClass(): string
    {
        return $this->linkClass;
    }

    public function setLinkClass(string $linkClass): void
    {
        $this->linkClass = $linkClass;
    }

    public function getNavTitle()
    {
        return $this->navTitle;
    }

    public function setNavTitle($navTitle): void
    {
        $this->navTitle = $navTitle;
    }

    public function getRealTitle()
    {
        return $this->getNavTitle() ?: $this->getTitle();
    }

    public function getAlias()
    {
        return $this->alias;
    }

    public function setAlias($alias): void
    {
        $this->alias = $alias;
    }

    public function getDoktype()
    {
        return $this->doktype;
    }

    public function setDoktype($doktype): void
    {
        $this->doktype = $doktype;
    }

    public function getUrl()
    {
        return $this->url;
    }

    public function setUrl($url): void
    {
        $this->url = $url;
    }

    public function getTarget()
    {
        return $this->target;
    }

    public function setTarget($target): void
    {
        $this->target = $target;
    }

    public function get_MP_PARAM()
    {
        //if(  $this->_MP_PARAM )
        return $this->_MP_PARAM;
        /*else if( $this->mountPid>0 )
    return $this->mountPid . '-' . $this->uid; //// $mount_pid . '-' . $firstPageUid,
    return null;*/
    }

    public function set_MP_PARAM($_MP_PARAM): void
    {
        $this->_MP_PARAM = $_MP_PARAM;
    }

    public function getIg_menu_icon()
    {
        return $this->ig_menu_icon;
    }

    public function setIg_menu_icon($ig_menu_icon): void
    {
        if ($ig_menu_icon > 0) {
            $fileRepository = GeneralUtility::makeInstance(FileRepository::class);
            $fileObjects = $fileRepository->findByRelation('pages', 'ig_menu_icon', $this->getUid())[0];
            $this->ig_menu_icon = $fileObjects;
        } else {
            $this->ig_menu_icon = $ig_menu_icon;
        }
    }

    public function getIg_menu_icon_position()
    {
        return $this->ig_menu_icon_position;
    }

    public function setIg_menu_icon_position($ig_menu_icon_position): void
    {
        $this->ig_menu_icon_position = $ig_menu_icon_position;
    }

    public function getIg_menu_content()
    {
        //$configurationManager = GeneralUtility::makeInstance(ConfigurationManager::class);
        //$cObj = $this->request->getAttribute('currentContentObject');
        $cObj = GeneralUtility::makeInstance(ContentObjectRenderer::class);
        $conf = [
            // CONTENT
            'table' => 'tt_content',
            'select.' => [
                'pidInList' => $this->getUid(),
                'where' => 'colPos = 33',
            ],
        ];
        //$content = $cObj->CONTENT($conf);
        $this->content = $cObj->cObjGetSingle('CONTENT', $conf);
        return $this->content;
    }

    public function getHas_ig_menu_content()
    {
        $hasContent = false;
        if (isset($this->content)) {
            $hasContent = true;
        } else {
            $this->getIg_menu_content();
            $hasContent = isset($this->content);
        }

        return $hasContent;
    }

    public function setIg_menu_content($ig_menu_content): void
    {
        $this->ig_menu_content = $ig_menu_content;
    }

    public function getIg_menu_content_position()
    {
        return $this->ig_menu_content_position;
    }

    public function setIg_menu_content_position($ig_menu_content_position): void
    {
        $this->ig_menu_content_position = $ig_menu_content_position;
    }

    public function setPosition($position): void
    {
        $this->position = $position;
    }

    public function getPosition()
    {
        return $this->position;
    }

    public function setShortcut($shortcut): void
    {
        $this->shortcut = $shortcut;
    }

    public function getShortcut()
    {
        return $this->shortcut;
    }

    public function setMountPid($mountPid): void
    {
        $this->mountPid = $mountPid;
    }

    public function getMountPid()
    {
        return $this->mountPid;
    }

    public function setMountPidOl($mountPidOl): void
    {
        $this->mountPidOl = $mountPidOl;
    }

    public function getMountPidOl()
    {
        return $this->mountPidOl;
    }

    public function setIsRoot($isRoot): void
    {
        $this->isRoot = $isRoot;
    }

    public function getIsRoot()
    {
        return $this->isRoot;
    }

    public function setIgMenuLayout($igMenuLayout): void
    {
        $this->igMenuLayout = $igMenuLayout;
    }

    public function getIgMenuLayout()
    {
        return $this->igMenuLayout;
    }

    public function setIgMenuSource($igMenuSource): void
    {
        $this->igMenuSource = $igMenuSource;
    }

    public function getIgMenuSource()
    {
        return $this->igMenuSource;
    }

    public function setIgMenuSourceOptions($igMenuSourceOptions): void
    {
        $flex = $igMenuSourceOptions === null ? [] : GeneralUtility::xml2array($igMenuSourceOptions);
        $values = [];
        if (isset($flex['data']['sDEF']['lDEF'])) {
            foreach ($flex['data']['sDEF']['lDEF'] as $name => $value) {
                $values[$name] = $value['vDEF'];
            }
        }

        $this->igMenuSourceOptions = $values;
    }

    public function getIgMenuSourceOptions()
    {
        return $this->igMenuSourceOptions;
    }

    public function getIgMenuSourceOption($name)
    {
        return $this->igMenuSourceOptions[$name] ?? null;
    }

    public function getIgMenuLayoutFilename()
    {
        return intval($this->igMenuLayout) > 0 ? $this->igMenuLayout : 'Default';
    }

    public function setIgMenuColWidth($igMenuColWidth): void
    {
        $this->igMenuColWidth = $igMenuColWidth;
    }

    public function getIgMenuColWidth()
    {
        return $this->igMenuColWidth;
    }

    public function setIgMenuLayoutCols($igMenuLayoutCols): void
    {
        $this->igMenuLayoutCols = $igMenuLayoutCols;
    }

    public function getIgMenuLayoutCols()
    {
        return $this->igMenuLayoutCols;
    }

    /*
    public function getIgMenuLayoutColsClass()
    {
        return $this->igMenuLayoutCols>0 ? 'ym-g' . round($this->igMenuColWidth / ($this->igMenuLayoutCols)* 100) : '';
    }
    */

    public function setIgMenuReplacementText($igMenuReplacementText): void
    {
        $this->igMenuReplacementText = $igMenuReplacementText;
    }

    public function getIgMenuReplacementText()
    {
        return $this->igMenuReplacementText;
    }

    public function getIgMenuItemClass()
    {
        return $this->igMenuItemClass;
    }

    public function setIgMenuItemClass($igMenuItemClass): void
    {
        $this->igMenuItemClass = $igMenuItemClass;
    }

    public function getClassesReplacement()
    {
        // get settings
        $uid = $this->getUid();
        $alias = $this->getAlias();
        $item = ' item-' . $uid;
        $itemAlias = ($alias ? '  item-' . $alias : '');
        $doktype = ($this->getDoktype() ? ' doktype-' . $this->getDoktype() : '');
        $position = !empty($this->getPosition()) ? ' ' . $this->getPosition() : '';
        $hasImage = ($this->getIg_menu_icon() ? ' hasImage' : '');
        return trim($item . $doktype . $itemAlias . $position . $hasImage);
    }

    public function getClasses()
    {
        // get settings
        $this->settings = GeneralUtility::makeInstance(SettingsUtility::class)->getSettings();
        // get states

        $uid = $this->getUid();
        $alias = $this->getAlias();
        $item = ' item-' . $uid;
        /*
        if(!empty($this->actives)) {
                        foreach($this->actives as $name=>$value) {
                $item .= '-' . $name . '-' . $value;
            }
        }
        */
        if (!empty($this->activeKey)) {
            $item .= '-' . $this->activeKey;
        }

        // @todo da muss pageUid + MenuItemID rein oder setUid setzt solchen string
        // item-pagUid-category-uid  <ig:menu arguments="{category: 'tx_igshop2[category]'}" />
        $itemAlias = ($alias ? '  item-' . $alias : '');
        $doktype = ' doktype-' . ($this->getDoktype() ?: 'db');
        $position = !empty($this->getPosition()) ? ' ' . $this->getPosition() : '';
        $hasImage = ($this->getIg_menu_icon() ? ' hasImage' : '');
        $menuItemClass = $this->getIgMenuItemClass() ? ' ' . $this->getIgMenuItemClass() : '';
        /*
        $IFSUB = $this->getIfSub();
        if ($IFSUB) {
            $classes = $this->settings['IFSUB'];
        }
        $classes .
        */
        return trim($item . $doktype . $itemAlias . $position . $hasImage . $menuItemClass);
    }


    public function getIgMenuColumns()
    {
        return $this->ig_menu_columns;
    }

    public function setIgMenuColumns($ig_menu_columns): void
    {
        $this->ig_menu_columns = $ig_menu_columns;
    }

    /*
    public function getIfSub()
    {
        return false;//$this->getChildrenCount() > 0 ? true : false;
    }
    // Existiert Page Overlay
    */
    public function getShow()
    {
        return true;
    }

    public function getIgMenuIsMenuroot()
    {
        return $this->ig_menu_is_menuroot;
    }

    public function setIgMenuIsMenuroot($ig_menu_is_menuroot): void
    {
        $this->ig_menu_is_menuroot = $ig_menu_is_menuroot;
    }
    public function getIgMenuHideSubmenu()
    {
        return $this->ig_menu_hide_submenu;
    }
    public function setIgMenuHideSubmenu($ig_menu_hide_submenu): void
    {
        $this->ig_menu_hide_submenu = $ig_menu_hide_submenu;
    }
}
