<?php

namespace Ig\IgMenu\Hooks;

use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\DataHandling\DataHandler;
use TYPO3\CMS\Core\Http\ServerRequest;
use TYPO3\CMS\Core\Utility\GeneralUtility;

//class ClearCacheHook implements \TYPO3\CMS\Backend\Toolbar\ClearCacheActionsHookInterface
class ClearCacheHook
{
    /**
     * This method is called by the CacheMenuItem in the Backend
     *
     * @param ServerRequest $params
     * @param DataHandler $dataHandler
     */
    public static function clear(&$params, &$dataHandler): void
    {
        if (isset($params['cacheCmd']) && $params['cacheCmd'] == 'ig_menu') {// it is our cache, that should be flushed
            // check, if dir exists
            $dir = Environment::getPublicPath() . '/' . 'typo3temp/ig_menu/';
            if (is_dir($dir)) {
                // get the files and remove all except . and ..
                if ($handle = opendir($dir)) {
                    while (false !== ($filename = readdir($handle))) {
                        if ($filename != '.' && $filename != '..') {
                            @unlink($dir . $filename);
                        }
                    }

                    closedir($handle);
                }
            }

            $cacheManager = GeneralUtility::makeInstance(CacheManager::class);
            // flush all caches
            if ($cacheManager->hasCache('ig_menu')) {
                $cacheManager->getCache('ig_menu')
->flush();
            }

            $cacheManager->flushCaches();
        }
    }
}
