(function($) {
    var onTarget = '';
    var fixedOffsetAdd = 20;
    var fixedOffset = $('#header').outerHeight() + fixedOffsetAdd;
    $(document).ready(function() {
        setAnchorVariables();
        $('.menu_main li.onepage a').click(function(e) {
            // Klick nicht auf dieser Seite oder externer Link
            if (!$(this).parent().parent().parent().hasClass('active') || $(this).hasClass('external')) {
                return;
            } else {
                /// Mobile Ansicht -> Navi schliessen
                if ($('html').hasClass('responsiveNavOpen')) {
                    $('.responsiveNavOpen .headerBox .burger').click();
                    // Normaler Link nehmene -> TODO verbessern
                } else {
                    e.preventDefault();
                    goToMenuPoint(e.target.hash);
                }
            }
        });
        $(window).smartresize(function() {
            setAnchorVariables();
        });
        $(document).on('scroll', function() {
            setActiveMenuEntry();
        });
        $(window).on("load", function() {
            // Nach laden zu hash springen
            if (window.location.hash) {
                goToMenuPoint(window.location.hash);
            }
            setActiveMenuEntry();
        });

        function setActiveMenuEntry() {
            var headerHeight = $('#header').outerHeight() + fixedOffsetAdd;
            var scrollTop = $(window).scrollTop() + headerHeight;
            $('.tx-bwrk-onepage > section').each(function(index) {
                var $menuItem = $('.menu_main #onepage-' + $(this).attr('id'));

                if ($menuItem.length != 0 && scrollTop > $(this).offset().top) {
                    $('.menu_main li.onepage').removeClass('active');
                    $menuItem.addClass('active');
                } else if (index == 1) {
                    $menuItem.removeClass('active');
                }
            });
        }

        function goToMenuPoint(target) {
            containerOffset = $('.contentColumns').scrollTop();
            contentOffset = $(target).offset().top;
            if ($('.contentColumns').offset().top != $(target).offset().top) {
                scroll = containerOffset + contentOffset - fixedOffset;
            }
            animateScrollTop(scroll);
        }

        function animateScrollTop(scroll) {
            onTarget.stop().animate({
                scrollTop: scroll
            }, 1000);
        }

        function setAnchorVariables() {
            onTarget = $("html,body");
            fixedOffset = $('#header').outerHeight() - 1 + fixedOffsetAdd;
        }

    });
})(jQuery);
