<?php

namespace Ig\IgMenu\ViewHelpers;

use Ig\IgMenu\Utility\SettingsUtility;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\VersionNumberUtility;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class MenuRootViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    protected $menuConfig;

    public function initializeArguments(): void
    {
        $this->registerArgument('entryLevel', 'int', 'Default Entry Level', true);
    }

    public function render(): string
    {
        $this->menuConfig = GeneralUtility::makeInstance(SettingsUtility::class);
        $debug = false;
        $hasSubmenu = false;
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('pages');
        if (VersionNumberUtility::convertVersionNumberToInteger(
            VersionNumberUtility::getNumericTypo3Version()
        ) < 13000000) {
            $rootline = $GLOBALS['TSFE']->rootLine;
        } else {
            $request = $this->menuConfig->getRenderingContextRequest($this->renderingContext);
            $rootLine = array_reverse($request->getAttribute('frontend.page.information')->getLocalRootLine());
        }
        $rootLinePids = [];
        foreach ($rootLine as $page) {
            if (!$page['is_siteroot'] && $page['doktype'] != 254) {
                $rootLinePids[] = $page['uid'];
            }
        }

        $entryLevel = (int)$this->arguments['entryLevel'];
        // reverve rootline
        $rootLinePids = array_reverse($rootLinePids);
        // lookup parent that has ig_menu_is_menuroot
        if ($debug) {
            DebuggerUtility::var_dump($entryLevel, 'entry before');
            DebuggerUtility::var_dump(count($rootLine), 'rootLine count');
            DebuggerUtility::var_dump(count($rootLinePids), 'rootLinePids count');
        }

        $hasMenuRoot = false;
        $menuRootEntryLevel = $entryLevel;
        foreach ($rootLinePids as $pageUid) {
            --$menuRootEntryLevel;
            // only menu root 
            $menuRootSql = 'SELECT uid FROM pages WHERE uid = ' . $pageUid . ' AND ig_menu_is_menuroot = 1 AND deleted = 0 AND hidden = 0';
            // menu root and hidden in top menu
            // $menuRootAndHiddenSql = 'SELECT uid FROM pages WHERE uid = ' . $pageUid . ' AND ig_menu_is_menuroot = 1 AND ig_menu_hide_submenu = 1 AND deleted = 0 AND hidden = 0';
            $result = $conn->executeQuery($menuRootSql)->fetchOne();
            // if(!$result){
            //     $result = $conn->executeQuery($menuRootAndHiddenSql)->fetchOne();
            // }
            if (is_numeric($result)) {
                $hasMenuRoot = true;
                break;
            }
        }

        if ($hasMenuRoot) {
            $hasSubmenu = true; // change that
            $entryLevel = $menuRootEntryLevel;
        } elseif (count($rootLinePids) > $entryLevel) {
            $hasSubmenu = true;
        }

        if ($debug) {
            DebuggerUtility::var_dump($entryLevel, 'entry after');
            DebuggerUtility::var_dump($hasMenuRoot, 'has ig_menu_is_menuroot');
        }

        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add('hasSubmenu', $hasSubmenu);
        $templateVariableContainer->add('entryLevel', $entryLevel);

        $content = $this->renderChildren();
        $templateVariableContainer->remove('hasSubmenu');
        $templateVariableContainer->remove('entryLevel');
        return $content;
    }
}
