<?php

namespace Ig\IgMenu\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ColsViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    
    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('children', 'array', 'Children Objects', false, []);
        $this->registerArgument('layout', 'string', 'UL Layout', false, '');
        $this->registerArgument('as', 'string', 'name of children', false, 'cols');
    }

    public function render(): string
    {
        $children = $this->arguments['children'];

        if ($this->arguments['layout'] == '' || $this->arguments['layout'] == '0') {
            $cols = $children;
        } elseif ($this->arguments['layout'] == '1') {
            // Veraltet - Seiten sind Spalten
            $cols = [];
            foreach ($children as $key => $menuPoint) {
                $cols[] = $menuObj->getChildren();
            }
        } elseif ($this->arguments['layout'] == '2' || $this->arguments['layout'] == '3' || $this->arguments['layout'] == '4') {
            $anzahlSpalten = intval($this->arguments['layout']);
            $cols = [];
            for ($i = 0;$i < $anzahlSpalten;++$i) {
                $cols[] = [];
            }

            $spalteCurrent = 0;
            $anzahlEintraege = count($children);
            $entraegeInCurrentSpalte = 0;
            $entraegeTodo = $anzahlEintraege;
            //echo($this->arguments['layout'] . 'anzahlSpalten='. $anzahlSpalten .'<br />');
            foreach ($children as $key => $menuPoint) {
                $anzahlEintraegeProSpalte = ceil($entraegeTodo / ($anzahlSpalten - $spalteCurrent));
                //echo('anzahlEintraegeProSpalte=' . $anzahlEintraegeProSpalte .',');
                if ($entraegeInCurrentSpalte == $anzahlEintraegeProSpalte) {
                    ++$spalteCurrent;
                    $entraegeTodo -= $anzahlEintraegeProSpalte;
                    $entraegeInCurrentSpalte = 0;
                }

                ++$entraegeInCurrentSpalte;
                if ($menuPoint->getIgMenuColumns() > 0) {
                    // - 1 because of array key start point 0
                    $cols[$menuPoint->getIgMenuColumns() - 1][] = $children[$key];
                } else {
                    $cols[$spalteCurrent][] = $children[$key];
                }
            }

            /*
              echo('pages='. count($children) .' Anzhal ='.$anzahlEintraege.'<br />');
              foreach($cols as $nr=>$col) {
              echo('COL '. $nr . '='. count($col) .'<br />');
              }
            */
        }

        //die($this->arguments['as'] .'='. count($cols));
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $cols);

        $content = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $content;
    }
}
