<?php
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
$tempColumns = [
    'ig_menu_icon' => [
        'exclude' => 0,
        'label' => 'Bild',
        'config' => [
            'type' => 'file',
            'appearance' => [
                'createNewRelationLinkTitle' => 'LLL:EXT:cms/locallang_ttc.xlf:images.addFileReference'
            ],
            'maxitems' => 1,
            'allowed' => 'common-image-types',
        ],
    ],
    'ig_menu_icon_position' => [
        'label' => 'Position',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'items' => [
                ['label' => '', 'value' => ''],
                ['label' => 'Rechts', 'value' => 'iRight'],
                ['label' => 'Links', 'value' => 'iLeft'],
                ['label' => 'Oben', 'value' => 'iTop'],
                ['label' => 'Unten', 'value' => 'iBottom']
            ],
            'size' => 1,
            'minitems' => 0,
            'maxitems' => 1,
        ]
    ],
    'ig_menu_content_position' => [
        'label' => 'Position',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'items' => [
                ['label' => '', 'value' => ''],
                ['label' => 'Content Rechts', 'value' => 'cRight'],
                ['label' => 'Content Links', 'value' => 'cLeft'],
                ['label' => 'Content Oben', 'value' => 'cTop'],
                ['label' => 'Content Unten', 'value' => 'cBottom']
            ],
            'size' => 1,
            'minitems' => 0,
            'maxitems' => 1,
        ]
    ],
    'ig_menu_content' => [
        'exclude' => 0,
        'label' => 'Elemente',
        'config' => [
            'type' => 'inline',
            'foreign_table' => 'tt_content',
            'foreign_field' => 'ig_menu_content',
            'overrideChildTca' => [
                'columns' => [
                    'colPos' => [
                        'config' => [
                            'default' => '33'
                        ],
                    ],
                    'CType' => [
                        'config' => [
                            'default' => 'textmedia'
                        ],
                    ],
                ],
            ],
            'maxitems' => 999,
            'appearance' => [
                'collapseAll' => 1,
                'levelLinksPosition' => 'top',
                'showSynchronizationLink' => 1,
                'showPossibleLocalizationRecords' => 1,
                'showAllLocalizationLink' => 1
            ],
        ],
    ],


    'ig_menu_source' => [
        'label' => 'Source',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'items' => [
                ['label' => 'Default (Unterseiten)', 'value' => '0'],
                ['label' => 'Onepager (Seitenlinks auf diese Seite mit #)', 'value' => '16'],
                //['label' => 'Database (Subeinträge aus Datenbank)', 'value' => '101'],
            ],
            'size' => 1,
            'minitems' => 0,
            'maxitems' => 1,
        ]
    ],

    'ig_menu_layout' => [
        'label' => 'Menu Layout',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'items' => [
                ['label' => 'Default (Seiten sind Menueinträge)', 'value' => '0'],
                ['label' => 'Spalten (Seiten sind Spaltenaufteilungen)', 'value' => '1'],
                ['label' => '2 Spalten (Seiten in zwei Spalten aufteilen)', 'value' => '2'],
                ['label' => '3 Spalten (Seiten in drei Spalten aufteilen)', 'value' => '3'],
                ['label' => '4 Spalten (Seiten in vier Spalten aufteilen)', 'value' => '4'],
                //                ['label' => 'Onepage (Seitenlinks auf aktuelle Seite mit #)', 'value' => '16'],
                //                ['label' => 'Database (Subeinträge aus Datenbank)', 'value' => '101'],
            ],
            'size' => 1,
            'minitems' => 0,
            'maxitems' => 1,
        ]
    ],

    'ig_menu_source_options' => [
        'exclude' => 1,
        'displayCond' => 'FIELD:ig_menu_source:REQ:true',
        'label' => 'Source Options',
        'config' => [
            'type' => 'flex',
            'ds_pointerField' => 'ig_menu_source',
            'ds' => [
                'default' => 'FILE:EXT:ig_menu/Configuration/FlexForms/Default.xml',
            ],
        ]
    ],

    'ig_menu_layout_cols' => [
        'displayCond' => 'FIELD:ig_menu_layout:=:1',
        'exclude' => 1,
        'label' => 'Anzahl Spalten',
        'config' => [
            'type' => 'number',
            'format' => 'integer',
            'nullable' => true,
            'size' => 10,
            'eval' => 'trim',
        ]
    ],


    'ig_menu_col_width' => [
        'displayCond' => 'FIELD:doktype:=:254',
        'label' => 'Spaltenmenus: Spaltenbreite',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'items' => [
                ['label' => '1 Einheit', 'value' => '1'],
                ['label' => '2 Einheiten', 'value' => '2'],
                ['label' => '3 Einheiten', 'value' => '3'],
                ['label' => '4 Einheiten', 'value' => '4'],
            ],
            'size' => 1,
            'minitems' => 0,
            'maxitems' => 1,
        ]
    ],
    'ig_menu_columns' => [
        'label' => 'Menu Columns',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'itemsProcFunc' => 'Ig\IgMenu\Backend\Service\IgMenuColumnService->columnsItemsProcFunc',
            'size' => 1,
            'minitems' => 0,
            'maxitems' => 1,
        ]
    ],
    'ig_menu_item_class' => [
        'exclude' => 1,
        'label' => 'Menu Klasse',
        'config' => [
            'type' => 'input',
            'size' => 20,
            'eval' => 'trim',
        ]
    ],

    'ig_menu_replacement_text' => [
        'label' => 'Replacement Text',
        'config' => [
            'type' => 'input',
            'size' => 60,
        ]
    ],
    'ig_menu_is_menuroot' => [
        'exclude' => 0,
        'label' => 'Startpunkt des Menüs',
        'config' => [
            'type' => 'check',
            'renderType' => 'checkboxToggle',
        ],
    ],
    'ig_menu_hide_submenu' => [
        'exclude' => 0,
        'label' => 'Unterseiten im Hauptmenu verbergen',
        'config' => [
            'type' => 'check',
            'renderType' => 'checkboxToggle',
        ],
    ],




];
ExtensionManagementUtility::addTCAcolumns('pages', $tempColumns);
ExtensionManagementUtility::addFieldsToPalette('pages', 'menu_icons', 'ig_menu_icon,ig_menu_icon_position');
ExtensionManagementUtility::addFieldsToPalette('pages', 'menu_content', 'ig_menu_content,ig_menu_content_position');
ExtensionManagementUtility::addFieldsToPalette('pages', 'menu_layout', 'ig_menu_source,ig_menu_layout,ig_menu_columns');
ExtensionManagementUtility::addFieldsToPalette('pages', 'menu_options', 'ig_menu_source_options,ig_menu_layout_cols,ig_menu_col_width,');
ExtensionManagementUtility::addToAllTCAtypes(
    'pages',
    '--div--;Menu,
    --palette--;Layout;menu_layout,
    --palette--;Layout;menu_options,
    --palette--;Icon;menu_icons,
    --palette--;Inhalt;menu_content,
    ig_menu_replacement_text,ig_menu_item_class',
    '',
    'after:content_from_pid'
);
ExtensionManagementUtility::addFieldsToPalette(
    'pages',
    'visibility',
    'ig_menu_is_menuroot,ig_menu_hide_submenu',
    'after:ig_hide_in_sitemap'
);
//ig_menu_source_options,ig_menu_layout_cols,ig_menu_col_width,
