/*
 *************************************
 * menuswipe.js
 * Menu Swipe Javascript
 *************************************
 */

(function($) {
    var swipeThreshold = 0.6;
    $(document).ready(function() {
        //Check if device has touch
        if ($("html").hasClass("touch")) {
            initTouchSwipe();
        }

        function initTouchSwipe() {
            var thresholdWidth = parseInt($(window).width() * swipeThreshold);
            $('html').swipe({
                allowPageScroll: "vertical",
                swipe: function(event, direction, distance, duration, fingerCount, fingerData) {
                    if (distance > thresholdWidth) {
                        // navigation is NOT open
                        if ($('html.responsiveNavOpen').length == 0) {
                            if (($('html.rnLeftToRight').length > 0 && direction == 'right') || ($('html.rnRightToLeft').length > 0 && direction == 'left')) {
                                $('.headerBox .burger').click();
                            }
                            // navigation is open
                        } else if ($('html.responsiveNavOpen').length == 1) {
                            if (($('html.rnLeftToRight').length > 0 && direction == 'left') || ($('html.rnRightToLeft').length > 0 && direction == 'right')) {
                                $('.headerBox .burger').click();
                            }
                        }
                    }
                }
            });
        }
    });
})(jQuery);
