<?php

namespace Ig\IgMenu\Utility;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Fluid\View\StandaloneView;

class RenderUtility
{
    protected $settings;

    public function __construct()
    {
        $this->settings = GeneralUtility::makeInstance(SettingsUtility::class);
    }

    public function getTemplateHtml($template, array $variables = [], $request = null)
    {
        $view = GeneralUtility::makeInstance(StandaloneView::class);
        if ($request && method_exists($view, 'setRequest')) {
            $view->setRequest($request);
        }
        $view->setLayoutRootPaths($this->settings->getView('layoutRootPaths'));
        $view->setPartialRootPaths($this->settings->getView('partialRootPaths'));
        $view->setTemplateRootPaths($this->settings->getView('templateRootPaths'));
        $view->setTemplate($template . '.html');
        $view->assignMultiple($variables);
        return $view->render();
    }
}
