<?php

namespace Ig\IgMenu\Utility;

use Ig\IgMenu\DataProcessing\PagesProcessor;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class SettingsUtility implements SingletonInterface
{
    protected $settings;

    protected $arguments = [];

    protected $level = -1;

    protected $partialLink = 'Page';

    protected $replacementText = null;

    protected $currentDataProcessing = PagesProcessor::class;

    protected $dataProcessing = [];

    public function __construct()
    {
        $configurationManager = GeneralUtility::makeInstance(ConfigurationManagerInterface::class);
        $setting = $configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
        );
        $this->settings = $setting['plugin.']['tx_igmenu_menu.'];
        $this->replacementText = LocalizationUtility::translate('ig_menu.replacement', 'ig_menu');
    }

    public function load($arguments = [])
    {
        if ($this->getLevel() != -1) {
            return false;
        }

        $this->arguments = [
            'pagesToExclude' => '',
            'includeNotInMenu' => '',
            'maxLevel' => 1, // wert wird nie gebraucht, default ist in viewhelper
        ];
        // Make the arguments available for all sub parts
        foreach ($arguments as $name => $value) {
            if ($value) {
                $this->setArgument($name, $value);
            }
        }

        $this->setLevel(0);
        return true;
    }

    public function exit($rootLevel = 0): void
    {
        if ($rootLevel) {
            $this->setLevel(-1);
        }
    }

    public function getView($type = null)
    {
        if ($type) {
            return $this->settings['view.'][$type . '.'];
        }
        return $this->settings['view.'];
    }

    public function getPersistence($type = null)
    {
        if ($type) {
            return $this->settings['persistence.'][$type];
        }
        return $this->settings['persistence.'];
    }

    public function getSettings($type = null)
    {
        if ($type) {
            return $this->settings['settings.'][$type];
        }
        return $this->settings['settings.'];
    }

    public function getSetting($name, $type = null)
    {
        return $this->settings['settings.'][$name];
    }

    public function getSettingsConfig()
    {
        $name = $this->arguments['name'];
        if (!isset($this->settings['settings.']['config.'])) {
            return false;
        }

        if (!isset($this->settings['settings.']['config.'][$name . '.'])) {
            return false;
        }

        if (!isset($this->settings['settings.']['config.'][$name . '.'][$this->level . '.'])) {
            return false;
        }

        return $this->settings['settings.']['config.'][$name . '.'][$this->level . '.'];
    }

    public function setArgument($name, $value): void
    {
        $this->arguments[$name] = $value;
    }

    public function getArgument($name)
    {
        return $this->arguments[$name] ?? null;
    }

    public function getArguments()
    {
        return $this->arguments;
    }

    public function getArgumentSetting($name)
    {
        if ($this->arguments[$name]) {
            return $this->arguments[$name];
        }

        return $this->getSetting($name);
    }

    public function getMd5($extraString = '')
    {
        return md5($extraString . '-S' . json_encode($this->getSettings()) . '-A' . json_encode($this->arguments));
    }


    public function setLevel($level): void
    {
        $this->level = $level;
    }

    public function getLevel()
    {
        return $this->level;
    }

    public function setPartialLink($partialLink): void
    {
        $this->partialLink = $partialLink;
    }

    public function getPartialLink()
    {
        return $this->partialLink;
    }

    public function getDataProcessing()
    {
        return $this->dataProcessing;
    }

    public function getCurrentDataProcessing()
    {
        return $this->currentDataProcessing;
    }

    public function setCurrentDataProcessing($currentDataProcessing): void
    {
        $this->currentDataProcessing = $currentDataProcessing;
    }

    public function addDataProcessing(string $dataProcessing): void
    {
        $this->dataProcessing[$dataProcessing] = $dataProcessing;
        $this->setCurrentDataProcessing($dataProcessing);
    }

    // lieferte alle arguments, settings etc. fuer Partials/Templates
    public function getVariables($argumentsLocal = [])
    {
        // Globale Argumente
        $arguments = $this->getArguments();

        // zusammenfuehren mit Argumenten vom aktuellen ViewHelper ( geht wohl nur um replacemnet  -> sonst stack bilden )
        foreach ($argumentsLocal as $name => $value) {
            if ($value) {
                $arguments[$name] = $value;
            }
        }

        return [
            'arguments' => $arguments,
            'settings' => $this->getSettings(),
            //'level' => $this->level,
            'partialLink' => $this->partialLink,
            'replacementText' => $this->replacementText,
            'replacement' => $arguments['replacement'] ?? '',
        ];
    }

    public function getMenuProperties()
    {
        return [
            'level' => intval($this->level),
            'maxLevel' => $this->getArgument('maxLevel'),
        ];
    }
    public function getRenderingContextRequest($renderingContext): mixed
    {
        if (
            method_exists($renderingContext, 'getAttribute') &&
            method_exists($renderingContext, 'hasAttribute') &&
            $renderingContext->hasAttribute(ServerRequestInterface::class)
        ) {
            $request = $renderingContext->getAttribute(ServerRequestInterface::class);
        } else {
            $request = $renderingContext->getRequest();
        }
        return $request;
    }
}
