<?php

namespace Ig\IgMenu\ViewHelpers;

use Ig\IgMenu\Source\DataProcessorInterface;
use Ig\IgMenu\Utility\RenderUtility;
use Ig\IgMenu\Utility\SettingsUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

class ClassViewHelper extends AbstractTagBasedViewHelper
{
    protected $render = null;

    protected $menuConfig = null;


    public function initializeArguments(): void
    {
        parent::initializeArguments();
        //$this->registerArgument('recursiveSettings', 'array', 'recursive Settings', false, '');
        $this->registerArgument('replacement', 'object', 'Replacement', false, '');
        //$this->registerArgument('menu', 'array', 'Menu Part', false, '');
        //$this->registerArgument('pages', 'array', 'Unterseiten', false, '');
        $this->registerArgument('page', 'mixed', 'Seite für Verlinkung', false, null);
        $this->registerArgument('classname', 'string', 'Implementation ClassName', false, '');
    }

    public function render()
    {
        $this->menuConfig = GeneralUtility::makeInstance(SettingsUtility::class);
        $this->render = GeneralUtility::makeInstance(RenderUtility::class);
        $page = $this->arguments['page'];
        $replacement = $this->arguments['replacement'];
        if (!$this->arguments['classname']) {
            return '';
        }

        $rootLevel = $this->menuConfig->load($this->arguments);

        $implementationClassName = $this->arguments['classname'];
        $obj = GeneralUtility::makeInstance($implementationClassName);
        if ($obj instanceof DataProcessorInterface) {
            $this->menuConfig->addDataProcessing($implementationClassName);
            $entries = $obj->process($this->renderingContext, $page);
        } else {
            die('object ' . $obj::class . ' missing interface \Ig\IgMenu\ContentObject\DataProcessorInterface');
        }

        $menuVariables = $this->menuConfig->getVariables($this->arguments);
        $menuVariables['pages'] = $entries;
        $menuVariables['page'] = $page;
        $content = $this->render->getTemplateHtml(
            'Class',
            $menuVariables,
            $this->menuConfig->getRenderingContextRequest($this->renderingContext)
        );
        $this->menuConfig->exit($rootLevel);
        return $content;
    }
}
