<?php

declare(strict_types=1);

namespace Ig\IgMenu\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * Command for clearing menu caches
 */
class ClearCacheCommand extends Command
{
    /**
     * Defines the allowed options for this command
     */
    protected function configure()
    {
        $this
          ->setDescription('clear menu caches')
            //->setHelp('The extension files must be present in one of the recognized extension folder paths in TYPO3.')
          ->setAliases(['ig:menu'])
          ->addArgument('search', InputArgument::OPTIONAL, 'clear only caches with given criteria');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $io = new SymfonyStyle($input, $output);
        $search = $input->getArgument('search');

        $dir = Environment::getPublicPath() . '/' . 'typo3temp/ig_menu/';
        if (is_dir($dir)) {
            // get the files and remove all except . and ..
            if ($handle = opendir($dir)) {
                while (false !== ($filename = readdir($handle))) {
                    if ($filename != '.' && $filename != '..') {
                        @unlink($dir . $filename);
                    }
                }

                closedir($handle);
            }
        }

        //$io->writeln('<comment>' . print_r($GLOBALS['TYPO3_CONF_VARS']['SYS']['caching']['cacheConfigurations']['ig_menu'],true).'</comment>');



        $cacheManager = GeneralUtility::makeInstance(CacheManager::class);
        // flush all caches
        if ($cacheManager->hasCache('ig_menu')) {
            $cacheManager->getCache('ig_menu')
->flush();
        }

        //$cacheManager->flushCaches();

        $io->success('Menu Cache cleared');
        //$io->error('error');
        /*
        foreach($cacheManager->getCacheIdentifiers() as $identifier) {
            $io->writeln('<comment>' . $identifier . '</comment>');

        }
        */
        return 0;
    }
}
