<?php

namespace Ig\IgMenu\Domain\Repository;

/*
   @todo DA init ist fuer menu von unterseiten von system ordner z.B. utility
   besser ueber init Hook loesen
   Aenderung zu init aus typo3/sysext/frontend/Classes/Page/PageRepository.php -> 2 Mal:
   )//,
   //$expressionBuilder->lt('pages.doktype', 200)
   auskommentiert
*/

use PDO;
use TYPO3\CMS\Core\Context\LanguageAspect;
use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Query\QueryHelper;
use TYPO3\CMS\Core\Information\Typo3Version;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use UnexpectedValueException;

class PageRepository extends BasePageRepository
{
    /**
     * Returns an array with page rows for subpages of a certain page ID. This is used for menus in the frontend.
     * If there are mount points in overlay mode the _MP_PARAM field is set to the correct MPvar.
     *
     * If the $pageId being input does in itself require MPvars to define a correct
     * rootline these must be handled externally to this function.
     *
     * @param int|int[] $pageId The page id (or array of page ids) for which to fetch subpages (PID)
     * @param string $fields List of fields to select. Default is "*" = all
     * @param string $sortField The field to sort by. Default is "sorting
     * @param string $additionalWhereClause Optional additional where clauses. Like "AND title like '%blabla%'" for instance.
     * @param bool $checkShortcuts Check if shortcuts exist, checks by default
     * @return array Array with key/value pairs; keys are page-uid numbers. values are the corresponding page records (with overlaid localized fields, if any)
     * @see self::getPageShortcut(), \TYPO3\CMS\Frontend\ContentObject\Menu\AbstractMenuContentObject::makeMenu()
     */
    public function getIgMenu(
        $pageId,
        $fields = '*',
        $sortField = 'sorting',
        $additionalWhereClause = '',
        $checkShortcuts = true
    ) {
        return $this->getSubpagesForIgMenu(
            (array)$pageId,
            $fields,
            $sortField,
            $additionalWhereClause,
            $checkShortcuts
        );
    }

    /* get l10n_parent for mountpoints */
    public function getL10nParent($uid)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('pages');
        $page = $queryBuilder
              ->select('l10n_parent')
              ->from('pages')
              ->where($queryBuilder->expr() ->eq('uid', $queryBuilder->createNamedParameter($uid, PDO::PARAM_INT)))
              ->execute()
              ->fetch();
        
        return $page['l10n_parent'];
        return $uid;
    }


    /**
     * init() MUST be run directly after creating a new template-object
     * This sets the internal variable $this->where_hid_del to the correct where
     * clause for page records taking deleted/hidden/starttime/endtime/t3ver_state
     * into account
     *
     * @internal
     */
    protected function initMenu($includeHiddenPagesV12 = null): void
    {
        $this->where_groupAccess = '';
        if ($includeHiddenPagesV12 === null) {
            $includeHiddenPages = $this->context->getPropertyFromAspect('visibility', 'includeHiddenPages');
        } else {
            $includeHiddenPages = $includeHiddenPagesV12;
        }

        $typo3Version = GeneralUtility::makeInstance(Typo3Version::class);
        $workspaceId = (int)$this->context->getPropertyFromAspect('workspace', 'id');

        $cache = $this->getRuntimeCache();
        $cacheIdentifier = 'PageRepository_hidDelWhere' . ($includeHiddenPages ? 'ShowHidden' : '') . '_' . (string)$workspaceId;
        $cacheEntry = $cache->get($cacheIdentifier);
        if ($cacheEntry) {
            $this->where_hid_del = $cacheEntry;
        } else {
            $expressionBuilder = GeneralUtility::makeInstance(ConnectionPool::class)
                ->getQueryBuilderForTable('pages')
                ->expr();
            if ($workspaceId > 0) {
                // For version previewing, make sure that enable-fields are not
                // de-selecting hidden pages - we need versionOL() to unset them only
                // if the overlay record instructs us to.
                // Clear where_hid_del and restrict to live and current workspaces
                //$this->where_hid_del = ' AND ' . $expressionBuilder->and(
                $sqlAnd = $typo3Version->getMajorVersion() < 13 ? ' AND ' : '';
                $this->where_hid_del = $sqlAnd . (string)$expressionBuilder->and(
                    $expressionBuilder->eq('pages.deleted', 0),
                    $expressionBuilder->or(
                        $expressionBuilder->eq('pages.t3ver_wsid', 0),
                        $expressionBuilder->eq('pages.t3ver_wsid', $workspaceId)
                    )
                    //, $expressionBuilder->neq('pages.doktype', self::DOKTYPE_RECYCLER)
                );
            } else {
                // add starttime / endtime, and check for hidden/deleted
                // Filter out new/deleted place-holder pages in case we are NOT in a
                // versioning preview (that means we are online!)
                //$this->where_hid_del = ' AND ' . (string)$expressionBuilder->and(
                $sqlAnd = $typo3Version->getMajorVersion() < 13 ? ' AND ' : '';
                $this->where_hid_del = $sqlAnd . (string)$expressionBuilder->and(
                    QueryHelper::stripLogicalOperatorPrefix(
                        $this->enableFields('pages', $includeHiddenPages, [
                            'fe_group' => true,
                        ])
                    )
                    //, $expressionBuilder->neq('pages.doktype', self::DOKTYPE_RECYCLER)
                );
            }

            $cache->set($cacheIdentifier, $this->where_hid_del);
        }
        $this->where_groupAccess = $this->getMultipleGroupsWhereClause('pages.fe_group', 'pages');
        
        if (is_array($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS'][self::class]['init'] ?? false)) {
            foreach ($GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS'][self::class]['init'] as $classRef) {
                $hookObject = GeneralUtility::makeInstance($classRef);
                if (!$hookObject instanceof PageRepositoryInitHookInterface) {
                    throw new UnexpectedValueException(
                        $classRef . ' must implement interface ' . PageRepositoryInitHookInterface::class,
                        1379579812
                    );
                }

                $hookObject->init_postProcess($this);
            }
        }
    }

    /**
     * Loads page records either by PIDs or by UIDs.
     *
     * By default the subpages of the given page IDs are loaded (as the method name suggests). If $parentPages is set
     * to FALSE, the page records for the given page IDs are loaded directly.
     *
     * Concerning the rationale, please see these two other methods:
     *
     * @see PageRepository::getMenu()
     * @see PageRepository::getMenuForPages()
     *
     * Version and language overlay are applied to the loaded records.
     *
     * If a record is a mount point in overlay mode, the the overlaying page record is returned in place of the
     * record. The record is enriched by the field _MP_PARAM containing the mount point mapping for the mount
     * point.
     *
     * The query can be customized by setting fields, sorting and additional WHERE clauses. If additional WHERE
     * clauses are given, the clause must start with an operator, i.e: "AND title like '%blabla%'".
     *
     * The keys of the returned page records are the page UIDs.
     *
     * CAUTION: In case of an overlaid mount point, it is the original UID.
     *
     * @param int[] $pageIds PIDs or UIDs to load records for
     * @param string $fields fields to select
     * @param string $sortField the field to sort by
     * @param string $additionalWhereClause optional additional WHERE clause
     * @param bool $checkShortcuts whether to check if shortcuts exist
     * @param bool $parentPages Switch to load pages (false) or child pages (true).
     * @return array page records
     *
     * @see self::getPageShortcut()
     * @see \TYPO3\CMS\Frontend\ContentObject\Menu\AbstractMenuContentObject::makeMenu()
     */
    protected function getSubpagesForIgMenu(
        array $pageIds,
        string $fields = '*',
        string $sortField = 'sorting',
        string $additionalWhereClause = '',
        bool $checkShortcuts = true,
        bool $parentPages = true
    ): array {
        $relationField = $parentPages ? 'pid' : 'uid';
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('pages');
        $queryBuilder->getRestrictions()
->removeAll();

        $res = $queryBuilder->select(...GeneralUtility::trimExplode(',', $fields, true))
             ->from('pages')
             ->where(
                 $queryBuilder->expr()
->in($relationField, $queryBuilder->createNamedParameter($pageIds, Connection::PARAM_INT_ARRAY)),
                 $queryBuilder->expr()
->eq(
    $GLOBALS['TCA']['pages']['ctrl']['languageField'],
    (int)0
    //$queryBuilder->createNamedParameter(0, \PDO::PARAM_INT)
),
                 QueryHelper::stripLogicalOperatorPrefix($this->where_hid_del),
                 QueryHelper::stripLogicalOperatorPrefix($this->where_groupAccess),
                 QueryHelper::stripLogicalOperatorPrefix($additionalWhereClause)
             );

        if (!empty($sortField)) {
            $orderBy = QueryHelper::parseOrderBy($sortField);
            foreach ($orderBy as $order) {
                $res->addOrderBy($order[0], $order[1] ?? 'ASC');
                //$res->orderBy(...$order);
            }
        }

        $result = $res->executeQuery();

        $pages = [];
        while ($page = $result->fetchAssociative()) {
            $originalUid = $page['uid'];

            // Versioning Preview Overlay
            $this->versionOL('pages', $page, true);
            // Skip if page got disabled due to version overlay
            // (might be delete or move placeholder)
            if (empty($page)) {
                continue;
            }

            // Add a mount point parameter if needed
            //$page = $this->addMountPointParameterToPage((array)$page);

            // If shortcut, look up if the target exists and is currently visible
            if ($checkShortcuts) {
                // we do not want additionalWhereClause on shortcuts target (nav_hide, excludeUids should only work on shortcut )
                $page = $this->checkValidShortcutOfPage((array)$page, '');
            }

            // If the page still is there, we add it to the output
            if (!empty($page)) {
                $pages[$originalUid] = $page;
            }

            //if($originalUid==2194) {
            //var_dump($page);exit(0);
            //}
        }


        $overlayType = $this->context->getPropertyFromAspect('language', 'overlayType');

        // free: Ignore, fallback to default language
        if ($overlayType == LanguageAspect::OVERLAYS_OFF) {
            return $pages;
        }

        // fallback: ($overlayType ==LanguageAspect::OVERLAYS_MIXED and strict: LanguageAspect::OVERLAYS_ON_WITH_FLOATING
        $pagesOverlays = $this->getPagesOverlay($pages);

        // strict:  Same as "fallback" but remove the records that are not translated
        if ($overlayType == LanguageAspect::OVERLAYS_ON_WITH_FLOATING) {
            // remove pages with no overlay
            if ($this->context->getPropertyFromAspect('language', 'id') > 0) { // $GLOBALS['TSFE']->sys_language_uid
                foreach ($pagesOverlays as $pageOverlays) {
                    if (!$pageOverlays['_PAGES_OVERLAY']) {
                        unset($pagesOverlays[$pageOverlays['uid']]);
                    }
                }
            }
        }

        return $pagesOverlays;
    }
}
