<?php

namespace Ig\IgMenu\ViewHelpers;

use Closure;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/**
 * ColViewHelper
 */
class ColClassViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments()
    {
        $this->registerArgument('cols', 'int', 'Menu Cols', true);
        $this->registerArgument('width', 'int', 'width in Cols', false, 1);
        $this->registerArgument('prefix', 'string', 'prefix', false, 'ym-g');
    }



    /**
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        if ($arguments['cols'] <= 0) {
            return '';
        }

        $width = (int) $arguments['width'];
        if ($width <= 0) {
            $width = 1;
        }

        return $arguments['prefix'] . floor(100 * $width / $arguments['cols'] + 0.1);

        //$yamlArray = array(10, 20, 25, 30, 33, 38, 40, 50, 60, 62, 66, 70, 75, 80, 100);
    }

    /*
    public function getClosest($search, $arr)
    {
    $closest = null;
    foreach ($arr as $item) {
        if ($closest === null || abs($search - $closest) > abs($item - $search)) {
            $closest = $item;
        }
    }
    return $closest;
    }
    */
}
