<?php

namespace Ig\IgMenu\ViewHelpers;

use Ig\IgContentservBase\Utility\MenuUtility;
use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Cache\Frontend\FrontendInterface;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

//use Ig\IgContentservBase\Utility\MenuUtility;--> remove


// use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

/**
 * CachedMenu View Helper
 */
class CachedMenuViewHelper extends AbstractViewHelper
{
    // falls HTML Tages erlaubt sind
    protected $escapeOutput = false;

    /**
     * Context
     *
     * @var Context
     */
    protected $context = null;

    /**
     * @var ContentObjectRenderer
     */
    protected $contentObjectRenderer;

    /**
     * @var ConfigurationManagerInterface
     */
    protected $configurationManager;

    
    public function injectContentObjectRenderer(ContentObjectRenderer $contentObjectRenderer)
    {
        $this->contentObjectRenderer = $contentObjectRenderer;
    }

    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager)
    {
        $this->configurationManager = $configurationManager;
    }
    
    public function injectContext(Context $context)
    {
        $this->context = $context;
    }


    /**
     * Initialize the arguments.
     *
     * @api
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this -> registerArgument('lib', 'string', 'Typoscript Path', true);
    }


    /**
     * Menu/Typo3script rendern und Cachen
     *
     * @return string
     */
    public function render()
    {
        //$ts_path = explode('.',$this->arguments['typoscript'];
        $lib = $this->arguments['lib'];
        $typoScriptSetup = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
        );
        // Access the lib. section
        $ts = $typoScriptSetup['lib.'][$lib . '.'];
        //$ts = $GLOBALS['TSFE']->tmpl->setup['lib.'][$lib . '.'];
        
        //if($lib=='menu') {            var_dump( $ts);            die($lib);}
        // Mountpunkte -> werden hier gar nicht benoetigt
        $request = $this->renderingContext->getRequest();
        $mp = $request->getAttribute('frontend.page.information')->getMountPoint() ?? false;
        if ($mp) {
            $mp_array = explode('-', $mp);
            $mp = $mp_array[0];
        }

        // Usergruppen beruecksichtigen
        $userAspect = $this->context->getAspect('frontend.user');
        $userGroupIds = [];
        if ($userAspect->isLoggedIn()) {
            // enthaelt -2 show at any login und 0
            foreach ($userAspect->getGroupIds() as $gid) {
                if ($gid > 0) {
                    $userGroupIds[] = $gid;
                }
            }

            sort($userGroupIds);
        }

        $groups = implode('_', $userGroupIds);
        if ($groups) {
            $groups = '-fe_' . $groups;
        }

        $languageId = $this->context->getPropertyFromAspect('language', 'id');


        $currentDomain = preg_replace('/[^a-z]/i', '_', GeneralUtility::getIndpEnv('TYPO3_HOST_ONLY'));

        $cacheIdentifier = $lib . '--' . $currentDomain . '--' . $languageId . $groups;

        /** @var CacheManager $cacheManager */
        $cacheManager = GeneralUtility::makeInstance(CacheManager::class);
        /** @var FrontendInterface $menuCache */
        $menuCache = $cacheManager->getCache('ig_menu');
        $content = $menuCache->get($cacheIdentifier);
        if (!$content) {
            $content = str_replace(
                "\r",
                '',
                $this->contentObjectRenderer->cObjGetSingle(
                    $typoScriptSetup['lib.'][$lib],
                    $ts
                )
            );

            // ###CLASSES### reinbescheissen - falls nicht über TS
            $content = str_replace("\t", '', $content);
            $content = str_replace('activeSub ', '', $content);
            $content = str_replace(' activeSub', '', $content);
            $content = str_replace('subNavActive ', '', $content);
            $content = str_replace(' subNavActive', '', $content);
            $content = str_replace('"active"', '', $content);
            $content = str_replace(' active"', '', $content);
            $content = str_replace('-uid ig-menu-entry', '###CLASSES###', $content);
            //die('b=' . $this->context->getPropertyFromAspect('backend.user', 'isLoggedIn'));
            //if (!$this->context->getPropertyFromAspect('backend.user', 'isLoggedIn')) {
            $menuCache->set($cacheIdentifier, $content);
            //}
        }

        $request = $this->renderingContext->getRequest();
        $rootLine = $request->getAttribute('frontend.page.information')->getLocalRootLine();
        foreach ($rootline as $r) {
            $content = str_replace('item-' . $r['uid'] . '###CLASSES###', 'item-' . $r['uid'] . ' active', $content);
        }

        // "Activate" the contentserv tree along its 'rootline'
        // (contentserv nodes up to the root node id).
        $contentservNodesRootline = $this->getContentservRootline();

        if (!empty($contentservNodesRootline)) {
            foreach ($contentservNodesRootline as $rootLineEntry) {
                $content = str_replace(
                    'contentserv-item-' . $rootLineEntry,
                    'contentserv-item-' . $rootLineEntry . ' active',
                    $content
                );
            }
        }

        // Replace leftover markers
        $content = str_replace('###CLASSES###', '', $content);

        return $content;
    }


    /**
     * @param int $pageUid Ausgangspunkt / Root page
     * @param array $pageTree
     * @return array
     */
    protected function getPageTree($pageUid = 1, $pageTree = [])
    {
        $this->pageSelect = new t3lib_pageSelect();
        $this->pageSelect->init(true);

        $pageTree = $this->pageSelect->getMenu($pageUid);
        foreach ($pageTree as &$page) {
            $page['subPages'] = $this->getPageTree($page['uid'], $pageTree);
        }

        return $pageTree;
    }

    /**
     * Calculate the rootline of the currently displayed contentserv
     * node, providing a way of setting the cached menu entries active.
     *
     * @return array
     */
    protected function getContentservRootline()
    {
        $menuUtility = GeneralUtility::makeInstance(MenuUtility::class);
        $arguments = GeneralUtility::_GET('tx_contentserv_content') ?? GeneralUtility::_GET('tx_contentservcontent_contentservview');

        if (!isset($arguments['productgroup'])) {
            return [];
        }

        return $menuUtility->getContentservRootline((int) $arguments['productgroup'] / 100);
    }
}
