<?php

namespace Ig\IgMenu\ViewHelpers;

use Closure;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/**
 * ColsViewHelper
 */
class ColsViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    
    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('children', 'array', 'Children Objects', false, '');
        //$this->registerArgument('cols', 'integer', 'Settings', false, '2');
        $this->registerArgument('layout', 'string', 'UL Layout', false, '');
        $this->registerArgument('as', 'string', 'name of children', false, 'cols');
    }

    /**
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $children = $arguments['children'];

        if ($arguments['layout'] == '' || $arguments['layout'] == '0') {
            $cols = $children;
        } elseif ($arguments['layout'] == '1') {
            // Veraltet - Seiten sind Spalten
            $cols = [];
            foreach ($children as $key => $menuPoint) {
                $cols[] = $menuObj->getChildren();
            }
        } elseif ($arguments['layout'] == '2' || $arguments['layout'] == '3' || $arguments['layout'] == '4') {
            $anzahlSpalten = intval($arguments['layout']);
            $cols = [];
            for ($i = 0;$i < $anzahlSpalten;++$i) {
                $cols[] = [];
            }

            $spalteCurrent = 0;
            $anzahlEintraege = count($children);
            $entraegeInCurrentSpalte = 0;
            $entraegeTodo = $anzahlEintraege;
            //echo($arguments['layout'] . 'anzahlSpalten='. $anzahlSpalten .'<br />');
            foreach ($children as $key => $menuPoint) {
                $anzahlEintraegeProSpalte = ceil($entraegeTodo / ($anzahlSpalten - $spalteCurrent));
                //echo('anzahlEintraegeProSpalte=' . $anzahlEintraegeProSpalte .',');
                if ($entraegeInCurrentSpalte == $anzahlEintraegeProSpalte) {
                    ++$spalteCurrent;
                    $entraegeTodo -= $anzahlEintraegeProSpalte;
                    $entraegeInCurrentSpalte = 0;
                }

                ++$entraegeInCurrentSpalte;
                if ($menuPoint->getIgMenuColumns() > 0) {
                    // - 1 because of array key start point 0
                    $cols[$menuPoint->getIgMenuColumns() - 1][] = $children[$key];
                } else {
                    $cols[$spalteCurrent][] = $children[$key];
                }
            }

            /*
              echo('pages='. count($children) .' Anzhal ='.$anzahlEintraege.'<br />');
              foreach($cols as $nr=>$col) {
              echo('COL '. $nr . '='. count($col) .'<br />');
              }
            */
        }

        //die($arguments['as'] .'='. count($cols));
        $templateVariableContainer = $renderingContext->getVariableProvider();
        $templateVariableContainer->add($arguments['as'], $cols);

        $content = $renderChildrenClosure();
        $templateVariableContainer->remove($arguments['as']);
        return $content;
    }
}
