<?php

namespace Ig\IgMenu\ViewHelpers;

use Closure;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class MenuRootViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments()
    {
        $this->registerArgument('entryLevel', 'int', 'Default Entry Level', true);
    }

    public static function renderStatic(
        array $arguments,
        Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $debug = false;
        $hasSubmenu = false;
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('pages');
        $request = $this->renderingContext->getRequest();
        $rootLine = $request->getAttribute('frontend.page.information')->getLocalRootLine();

        $rootLinePids = [];
        foreach ($rootLine as $page) {
            if (!$page['is_siteroot'] && $page['doktype'] != 254) {
                $rootLinePids[] = $page['uid'];
            }
        }

        $entryLevel = (int)$arguments['entryLevel'];
        // reverve rootline
        $rootLinePids = array_reverse($rootLinePids);
        // lookup parent that has ig_menu_is_menuroot
        if ($debug) {
            DebuggerUtility::var_dump($entryLevel, 'entry before');
            DebuggerUtility::var_dump(count($rootLine), 'rootLine count');
            DebuggerUtility::var_dump(count($rootLinePids), 'rootLinePids count');
        }

        $hasMenuRoot = false;
        $menuRootEntryLevel = $entryLevel;
        foreach ($rootLinePids as $pageUid) {
            $sql = 'SELECT uid FROM pages WHERE uid = ' . $pageUid . ' AND ig_menu_is_menuroot = 1 AND deleted = 0 AND hidden = 0';
            --$menuRootEntryLevel;
            $stmt = $conn->executeQuery($sql);
            $result = $stmt->fetchOne();
            if (is_numeric($result)) {
                $hasMenuRoot = true;
                break;
            }
        }

        if ($hasMenuRoot) {
            $hasSubmenu = true; // change that
            $entryLevel = $menuRootEntryLevel;
        } elseif (count($rootLinePids) > $entryLevel) {
            $hasSubmenu = true;
        }

        if ($debug) {
            DebuggerUtility::var_dump($entryLevel, 'entry after');
            DebuggerUtility::var_dump($hasMenuRoot, 'has ig_menu_is_menuroot');
        }

        $templateVariableContainer = $renderingContext->getVariableProvider();
        $templateVariableContainer->add('hasSubmenu', $hasSubmenu);
        $templateVariableContainer->add('entryLevel', $entryLevel);

        $content = $renderChildrenClosure();
        $templateVariableContainer->remove('hasSubmenu');
        $templateVariableContainer->remove('entryLevel');
        return $content;
    }
}
