<?php

namespace Ig\IgMenu\ViewHelpers;

use Ig\IgMenu\Utility\SettingsUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

/**
 * PartialViewHelper
 */
class PartialViewHelper extends AbstractTagBasedViewHelper
{
    //protected $templateRootPaths;
    protected $partialRootPaths;

    //protected $error;

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('path', 'string', 'File exists', false, '');
    }

    public function render()
    {
        return false;
        $settings = GeneralUtility::makeInstance(SettingsUtility::class);
        // templateRootPaths ist nun array und geht natuerlich nicht mehr mit getFileAbsFileName
        $this->templateRootPaths = GeneralUtility::getFileAbsFileName($settings->getView('templateRootPaths'));
        $this->partialRootPaths = GeneralUtility::getFileAbsFileName($settings->getView('partialRootPaths'));

        $directory = $this->arguments['directory'];
        $path = $this->arguments['path'];
        //$error = [];
        if ($path && $this->pathExists($path) == true) {
            return true;
        }
        return false;
    }

    public function pathExists($path)
    {
        $pathparts = explode('/', (string) $path);
        $lowercase = implode('/', $pathparts);
        $ucfirst = implode('/', array_map('ucfirst', $pathparts));

        if (is_array($this->partialRootPaths)) {
            foreach ($this->partialRootPaths as $partialRootPath) {
                if (file_exists($partialRootPath . $path)) {
                    return true;
                }

                return false;
            }
        }

        if (file_exists($this->partialRootPaths . $path)) {
            return true;
        }

        return false;
        /*
          if(!is_numeric($path) && !file_exists($this->partialRootPaths . $path)){
          echo "renderType ".$path." does not exist!";exit;
          }
          if(!is_numeric($path) && file_exists($this->partialRootPaths . $path)){
          return true;
          }
          if (file_exists($this->templateRootPaths . $lowercase . '.html')) {
          return true;
          }
          if (file_exists($this->templateRootPaths . $ucfirst . '.html')) {
          return true;
          }
          if (file_exists($this->partialRootPaths . $lowercase . '.html')) {
          return true;
          }
          if (file_exists($this->partialRootPaths . $ucfirst . '.html')) {
          return true;
          }
          return false;
        */
    }
}
