<?php

namespace Ig\IgMenu\Backend\Service;

/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2018 FS <fs@internetgalerie.ch>, Internetgalerie
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class IgMenuColumnService implements SingletonInterface
{
    public function columnsItemsProcFunc(array &$params)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('pages');
        $pageParent = $queryBuilder->select('ig_menu_layout')
       ->from('pages')
       ->where($queryBuilder->expr() ->eq('uid', (int)$params['row']['pid']));
        $result = $pageParent->executeQuery()
->fetchAssociative();
        $params['items'][0] = ['', 0];
        if ($result) {
            $numbeOfColumns = intval($result['ig_menu_layout']);
            if ($numbeOfColumns >= 2 && $numbeOfColumns <= 4) {
                for ($col = 1; $col <= $numbeOfColumns; $col++) {
                    $params['items'][$col] = ['Spalte ' . $col, $col];
                }
            }
        }
        return $params['items'];
    }
}
