<?php

declare(strict_types=1);

namespace Ig\IgMenu\Source;

use Ig\IgMenu\Domain\Model\MenuItem;

interface DataProcessorInterface
{
    /**
     * Process content object data
     *
     * @param MenuItem $menuItem - the current menuItem
     */
    public function process(MenuItem $menuItem);

    /**
     * Process content object data
     */
    public function getChildren(MenuItem $menuItem);

    /**
     * Get Active Entries (Parameters with values)
     */
    public function getActiveKeys(int $pageUid, array $queryParams);
}
