<?php

namespace Ig\IgMenu\ViewHelpers;

use Ig\IgMenu\Domain\Model\MenuItem;
use Ig\IgMenu\Domain\Repository\PageRepository;
use Ig\IgMenu\Source\DataProcessorInterface;
use Ig\IgMenu\Utility\RenderUtility;
use Ig\IgMenu\Utility\SettingsUtility;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

/**
 * MenuViewHelper
 */
class MenuViewHelper extends AbstractTagBasedViewHelper
{
    /**
     * PageRepository
     *
     * @var PageRepository
     */
    public $pageRepository = null;

    /**
     * Context
     *
     * @var Context
     */
    protected $context = null;

    protected $menuConfig = null;

    protected $render = null;

    protected $menuSettings;

    public function injectPageRepository(PageRepository $pageRepository)
    {
        $this->pageRepository = $pageRepository;
    }

    public function injectContext(Context $context)
    {
        $this->context = $context;
    }

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('renderType', 'string', 'Render Type', false, '');
        $this->registerArgument('uid', 'int', 'Einstiegs UID', false, '');
        $this->registerArgument('entryLevel', 'int', 'Einstiegs Level', false, '');
        $this->registerArgument('maxLevel', 'int', 'Maximal Level', false, '');
        $this->registerArgument('pagesToExclude', 'string', 'Seiten nicht Rendern', false, '');
        $this->registerArgument('includeNotInMenu', 'boolean', 'Include Pages that are hidden in the menus', false, 0);
        $this->registerArgument('cols', 'string', 'Menu Cols', false, '');
        $this->registerArgument('colLevel', 'int', 'Col Level', false, '');
        $this->registerArgument('maxColLevel', 'int', 'Max Col Level', false, '');
        $this->registerArgument('replacement', 'object', 'Replacement', false, '');
        $this->registerArgument(
            'recursiveSettings',
            'array',
            'recursive Settings',
            false,
            ''
        ); // @todo bei Version 9.5 weg
        $this->registerArgument(
            'name',
            'string',
            'name for extra setttings.config - to override e.g. igMenuLayout',
            false,
            'menu'
        );
        $this->registerArgument('menu', 'array', 'Menu Part deprecated', false, []);
        $this->registerArgument('pages', 'array', 'Unterseiten', false, '');
        $this->registerArgument('page', 'mixed', 'Hauptseite -> Menu besteht aus Unterseiten', false, null);
        $this->registerArgument(
            'template',
            'string',
            'template name (default: Menu, possible definied values: MenuNoUl',
            false,
            'Menu'
        );
    }

    public function render()
    {
        $this->menuConfig = GeneralUtility::makeInstance(SettingsUtility::class);
        $this->render = GeneralUtility::makeInstance(RenderUtility::class);

        /*
        $dataProcessing = [
            0 => \InternetGalerie\Igshop2\DataProcessing\CategoriesProcessor::class
        ];
        */
        // Root Level - Menu Initialisieren
        $rootLevel = $this->menuConfig->load($this->arguments);
        //$this->viewHelperVariableContainer->add(\Ig\IgMenu\ViewHelpers\MenuViewHelper::class, 'name', $this->arguments['name']);
        $content = '';
        // to get only the id's of the col menupoints
        if (!empty($this->arguments['page'])) {
            $page = $this->arguments['page'];
            $obj = GeneralUtility::makeInstance(PagesProcessor::class);

            $content = $this->renderPartialWithPages($obj->getChildren($page)); // ['isRoot' => 1 ]
            $this->menuConfig->exit($rootLevel);
            //$this->viewHelperVariableContainer->remove(\Ig\IgMenu\ViewHelpers\MenuViewHelper::class, 'name');
            return $content;
        }

        if (!empty($this->arguments['pages'])) {
            $pages = $this->arguments['pages'];
            $content = $this->renderPartialWithPages($pages);
            $this->menuConfig->exit($rootLevel);
            //$this->viewHelperVariableContainer->remove(\Ig\IgMenu\ViewHelpers\MenuViewHelper::class, 'name');
            return $content;
        }


        // Menu mit UID $searchUid
        $searchUid = $this->arguments['entryLevel'] > 1 ? $this->getRootPageIdWithEntryLevel(
            $this->arguments['entryLevel']
        ) : $this->arguments['uid'];
        if ($searchUid === -1) {
            return '';
        }

        $rootPage = $this->pageRepository->getPage($searchUid);
        $menuItem = GeneralUtility::makeInstance(MenuItem::class);
        $menuVariables = $this->menuConfig->getVariables($this->arguments);
        $menuVariables['li'] = $menuItem->load($rootPage, [
            'position' => '',
            'isRoot' => 1,
        ]); //first
        $menuVariables['menu'] = $this->menuConfig->getMenuProperties();

        $md5OfQuery = $this->menuConfig->getMd5($searchUid);
        // returns filename
        $md5FileCache = $this->getCacheFile($md5OfQuery);
        // if it exists load it, if not make it
        $request = $this->renderingContext->getRequest();
        $menuDebug = $request->getParsedBody()['menuDebug'] ?? $request->getQueryParams()['menuDebug'] ?? false;
        if (
            !$this->menuConfig->getSettings()['noCache']
                && file_exists($md5FileCache)
                && filesize($md5FileCache) > 0
                && !$menuDebug
        ) {
            $this->menuConfig->exit($rootLevel);
            return $this->getCache($md5OfQuery);
        } elseif (!($request->getAttribute('frontend.page.information')->getMountPoint() ?? false)) {
            $debugLog = (bool) ($request->getParsedBody()['debugLog'] ?? $request->getQueryParams()['debugLog'] ?? false);
            $isAdmin = $this->context->getPropertyFromAspect('backend.user', 'isAdmin');
            if ($debugLog && $isAdmin) {
                $logFile = Environment::getPublicPath() . '/' . 'typo3temp/ig_menu_debuglog.log';
                $logData = 'ID:' . $searchUid . ' | all:' . implode(
                    ',',
                    array_keys($pages)
                ) . "\n"; // " | chunk:" . $implodedColMenuUids . "\n";
                file_put_contents($logFile, 'C > ' . $logData, FILE_APPEND);
            }

            $content = $this->render->getTemplateHtml($this->arguments['template'], $menuVariables, $request);
            //$content = $this->renderPartial($pages);
            // sets new cache
            if ($debugLog && $isAdmin) {
                file_put_contents($logFile, 'W > ' . $logData, FILE_APPEND);
            }

            $this->menuConfig->exit($rootLevel);
            return $this->setCache($md5OfQuery, $content);
        }
        // If we are on a page that is a mountpoint, don't generate the cache, because it would destroy other mountpoints that point to the same page
        $content = $this->render->getTemplateHtml(
            $this->arguments['template'],
            $menuVariables,
            $this->renderingContext->getRequest()
        );
        //$content = $this->renderPartial($pages);
        $content = str_replace(["\r", "\n", "\t"], '', $content);
        $content = preg_replace("/\s{2,}/", '', $content);
        $this->menuConfig->exit($rootLevel);
        $dataProcessing = $this->menuConfig->getDataProcessing();
        $data = $this->getData($content, $dataProcessing);
        return $this->getCacheWidthReplacements($data);
        

        $this->menuConfig->exit($rootLevel);
        return $content;
    }

    /* generating cache */
    public function renderPartialWithPages($menuObj)
    {
        $menuVariables = $this->menuConfig->getVariables();
        $menuVariables['pages'] = $menuObj;
        //$menuVariables = array('menu' => $menuObj, 'settings' => $this->allArguments, 'replacementText' => $this->replacementText,'replacement' => $this->replacement);
        $content = $this->render->getTemplateHtml('Ul', $menuVariables, $this->renderingContext->getRequest());

        return $content;
    }

    /* writes the cache */
    public function setCache(string $md5OfQuery, string $content)
    {
        $dataProcessing = $this->menuConfig->getDataProcessing();
        //$menuConfig = GeneralUtility::makeInstance(SettingsUtility::class);
        $content = str_replace(["\r", "\n", "\t"], '', $content);
        $content = preg_replace("/\s{2,}/", '', $content);

        $data = $this->getData($content, $dataProcessing);
        GeneralUtility::writeFileToTypo3tempDir($this->getCacheFile($md5OfQuery), json_encode($data));
        return $this->getCacheWidthReplacements($data);
    }

    /* adds classes from blank cached file */
    public function getCache(string $md5OfQuery)
    {
        $fileContent = file_get_contents($this->getCacheFile($md5OfQuery));
        $data = json_decode($fileContent, true);
        // old cache
        if ($data === null) {
            $data = $this->getData($fileContent);
        }

        return $this->getCacheWidthReplacements($data);
    }

    public function getCacheWidthReplacements($data)
    {
        $request = $this->renderingContext->getRequest();
        $name = $this->arguments['name'];
        $content = $data['content'];
        $activePages = $this->getActivePages();
        $queryParams = $request->getQueryParams();
        $pageArguments = $request->getAttribute('routing');
        $pageId = $pageArguments->getPageId();
        $activeMenuItemKeys = [];
        if (!empty($data['dataProcessing'])) {
            foreach ($data['dataProcessing'] as $dataProcessorClass) {
                $dataProcessor = GeneralUtility::makeInstance($dataProcessorClass);
                if ($dataProcessor instanceof DataProcessorInterface) {
                    $activeMenuItemKeys = array_merge(
                        $activeMenuItemKeys,
                        $dataProcessor->getActiveKeys($pageId, $queryParams)
                    );
                }
            }
        }

        //var_dump($category);exit(0);
        foreach ($activePages as $key => $activePage) {
            // write active classes
            /*
              if ($key == 0 && strpos($content, "item-" . $activePage . " doktype") && 0) {
              $content = str_replace("item-" . $activePage . " doktype", "item-" . $activePage . " " . $this->menuConfig->getSettings()['ACT'] . " doktype", $content);
              } else
            */
            if (isset($activePage['_MOUNT_PAGE']) && isset($activePage['_MOUNT_PAGE']['uid'])) {
                // Translated Mountpoints using translated Uids -> convert to default language
                if ($this->context->getPropertyFromAspect('language', 'id') > 0) {
                    $l10nParent = $this->pageRepository->getL10nParent($activePage['_MOUNT_PAGE']['uid']);
                    $activePageUid = $l10nParent > 0 ? $l10nParent : $activePage['_MOUNT_PAGE']['uid']; // ist wohl schwachsinn ist immer erfuellt
                } else {
                    $activePageUid = $activePage['_MOUNT_PAGE']['uid'];
                }
            } else {
                $activePageUid = $activePage['uid'];
            }

            if (strpos((string) $content, 'hasChild item-' . $activePageUid . ' doktype')) {
                $content = str_replace(
                    'hasChild item-' . $activePageUid . ' doktype',
                    'item-' . $activePageUid . ' ' . $this->menuConfig->getSettings()['ACTIFSUB'] . ' doktype',
                    $content
                );

                if ($activePageUid == $pageId) {
                    $content = str_replace(
                        'item-' . $activePageUid . ' doktype',
                        'item-' . $activePageUid . ' ' . $this->menuConfig->getSettings()['ACT'] . ' doktype',
                        $content
                    );
                    if (!empty($activeMenuItemKeys)) {
                        foreach ($activeMenuItemKeys as $value => $activeKey) {
                            $item = 'item-' . $activePageUid . ($activeKey ? '-' . $activeKey : '');
                            //die('hasChild:: item-' . $activePageUid . '-' . $name . '-' . $value. ' doktype');
                            $content = str_replace(
                                $item . ' doktype',
                                'item-' . $activePageUid . '-' . $name . '-' . $value . ' ' . $this->menuConfig->getSettings()['ACT'] . ' doktype',
                                $content
                            );
                        }
                    }
                }
            } elseif (strpos((string) $content, 'item-' . $activePageUid . ' doktype')) {
                $content = str_replace(
                    'item-' . $activePageUid . ' doktype',
                    'item-' . $activePageUid . ' ' . $this->menuConfig->getSettings()['ACT'] . ' doktype',
                    $content
                );
                if (!empty($activeMenuItemKeys)) {
                    foreach ($activeMenuItemKeys as $value => $activeKey) {
                        $item = 'item-' . $activePageUid . ($activeKey ? '-' . $activeKey : '');
                        //die('item-' . $activePageUid . '-' . $name . '-' . $value. ' doktype');
                        $content = str_replace(
                            $item . ' doktype',
                            'item-' . $activePageUid . '-' . $name . '-' . $value . ' ' . $this->menuConfig->getSettings()['ACT'] . ' doktype',
                            $content
                        );
                    }
                }
            }
        }

        return $content;
    }

    /* builds and returns absolute filename */
    public function getCacheFile($md5OfQuery)
    {
        $renderType = $this->menuConfig->getSettings()['renderType'];
        $userAspect = $this->context->getAspect('frontend.user');
        $userGroupIds = [];
        if ($userAspect->isLoggedIn()) {
            // enthaelt -2 show at any login und 0
            foreach ($userAspect->getGroupIds() as $gid) {
                if ($gid > 0) {
                    $userGroupIds[] = $gid;
                }
            }

            sort($userGroupIds);
        }

        $groups = implode('_', $userGroupIds);
        if ($groups) {
            $groups = '-fe_' . $groups;
        }

        $languageId = $this->context->getPropertyFromAspect('language', 'id');
        $additionalString = md5($md5OfQuery . '-' . $this->arguments['uid'] . '-lang_' . $languageId . $groups);
        if ($this->arguments['uid']) {
            $baseUid = $this->arguments['uid'] . '-';
        }

        /*
          if (!empty($this->arguments['menu']) && $this->arguments['replacement']->getUid()) {
          $baseUid = $this->arguments['replacement']->getUid() . '-';
          }
        */
        $cache_file = Environment::getPublicPath() . '/typo3temp/ig_menu/' . $renderType[0] . '-' . $baseUid . 'lang' . intval(
            $languageId
        ) . '-' . $additionalString . '.html';
        return $cache_file;
    }

    /* get array of active pages */
    private function getActivePages()
    {
        $ret = [];
        $pagesToExcludeArray = array_map('trim', explode(',', (string) $this->arguments['pagesToExclude']));

        if (\TYPO3\CMS\Core\Utility\VersionNumberUtility::convertVersionNumberToInteger(\TYPO3\CMS\Core\Utility\VersionNumberUtility::getNumericTypo3Version()) < 13000000) {
            $rootline = $GLOBALS['TSFE']->rootLine;
        } else {
            $request = $this->renderingContext->getRequest();
            $rootLine = $request->getAttribute('frontend.page.information')->getLocalRootLine();
        }
        foreach ($rootLine as $page) {
            $pageUid = $page['uid'];
            if (!in_array($pageUid, $pagesToExcludeArray)) {
                /*if($page['_MP_PARAM']) {
                  $pid = explode('-', $page['_MP_PARAM'])[1];
                  $page['pid'] = intval($pid);
                  }*/
                $ret[] = $page;
            }
        }

        return $ret;
    }

    /* get the roopage */
    private function getRootPageIdWithEntryLevel($entryLevel)
    {
        $activePages = $this->getActivePages();
        $activePagesCount = count($activePages);

        if ($activePagesCount > $entryLevel) {
            $activePage = $activePages[$activePagesCount - $entryLevel - 1];
            return $activePage['uid'];
        }

        return -1; //$this->arguments['uid'];
    }

    private function getData(string $content, array $dataProcessing = [])
    {
        return [
            'content' => $content,
            'dataProcessing' => $dataProcessing,
        ];
    }
}
