<?php

namespace Ig\IgMenu\ViewHelpers;

use Ig\IgMenu\Utility\RenderUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

/**
 * NavViewHelper
 */
class NavViewHelper extends AbstractTagBasedViewHelper
{
    protected $menuSettings;

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('renderType', 'string', 'Render Type', false, '');
        $this->registerArgument('uid', 'int', 'Einstiegs UID', false, '');
        $this->registerArgument('entryLevel', 'int', 'Einstiegs Level', false, '');
        $this->registerArgument('maxLevel', 'int', 'Maximal Level', false, '');
        $this->registerArgument('pagesToExclude', 'string', 'Seiten nicht Rendern', false, '');
        $this->registerArgument('includeNotInMenu', 'boolean', 'Include Pages that are hidden in the menus', false, 0);
        //$this->registerArgument('cols', 'string', 'Menu Cols', false, '');
        //$this->registerArgument('maxColLevel', 'int', 'Max Col Level', false, '');
        $this->registerArgument(
            'name',
            'string',
            'name for extra setttings.config - to override e.g. igMenuLayout',
            false,
            'menu'
        );
        $this->registerArgument('navClass', 'string', 'Nav Classes', false, '');
        $this->registerArgument('navId', 'string', 'Nav ID', false, '');
        $this->registerArgument('settings', 'string', 'Settings', false, '');
    }

    public function render()
    {
        $this->render = GeneralUtility::makeInstance(RenderUtility::class);
        $this->menuSettings = $this->arguments['settings'];

        // set fallback options
        $allArguments['uid'] = $this->arguments['uid'];

        $allArguments['entryLevel'] = $this->fallbackChecks('entryLevel', 1);
        $allArguments['maxLevel'] = $this->fallbackChecks('maxLevel', 10);
        $allArguments['pagesToExclude'] = $this->fallbackChecks('pagesToExclude');
        $allArguments['includeNotInMenu'] = $this->fallbackChecks('includeNotInMenu');
        //$allArguments['cols'] = $this->fallbackChecks('cols', 4);
        //$allArguments['maxColLevel'] = $this->fallbackChecks('maxColLevel', 2);
        $allArguments['renderType'] = $this->fallbackChecks('renderType');
        $allArguments['navClass'] = $this->fallbackChecks('navClass');
        $allArguments['navId'] = $this->fallbackChecks('navId');
        $allArguments['name'] = $this->fallbackChecks('name');
        $ariaArray = $this->fallbackChecks('aria') ?? [];
        //var_dump($ariaArray);
        foreach ($ariaArray as $key => $aria) {
            $allArguments['aria'] .= 'aria-' . $key . '="' . $aria . '" ';
        }

        $menuVariables = [
            'menuArguments' => $allArguments,
        ];
        $content = $this->render->getTemplateHtml('Nav', $menuVariables, $this->renderingContext->getRequest());
        return $content;
    }

    public function fallbackChecks($argument, $fallback = null)
    {
        if (!empty($this->arguments[$argument])) {
            return $this->arguments[$argument];
        }
        if (isset($this->menuSettings[$argument])) {
            return $this->menuSettings[$argument];
        }
        return $fallback;
    }
}
