<?php

namespace Ig\IgMenu\Toolbar;

use TYPO3\CMS\Backend\Backend\Event\ModifyClearCacheActionsEvent;
use TYPO3\CMS\Backend\Routing\UriBuilder;
use TYPO3\CMS\Core\Utility\GeneralUtility;

final class MenuClearCacheEventListener
{
    public function __invoke(ModifyClearCacheActionsEvent $event): void
    {
        $uriBuilder = GeneralUtility::makeInstance(UriBuilder::class);
        //$iconFactory = GeneralUtility::makeInstance(IconFactory::class);
        //$icon = $iconFactory -> getIcon('actions-system-cache-clear-impact-low', Icon::SIZE_SMALL);

        $cacheAction = [
            'id' => 'ig_menu',
            'title' => 'LLL:EXT:ig_menu/Resources/Private/Language/locallang:ig_menu.flushPageCachesTitle',
            'description' => 'LLL:EXT:ig_menu/Resources/Private/Language/locallang:ig_menu.flushPageCachesDescription',
            'href' => (string)$uriBuilder->buildUriFromRoute('tce_db', [
                'cacheCmd' => 'ig_menu',
            ]),
            'severity' => 'danger',
            'iconIdentifier' => 'actions-system-cache-clear-impact-high',
        ];
        
        $event->addCacheAction($cacheAction);
        $event->addCacheActionIdentifier('ig_menu');
    }
}
