/*
 *************************************
 * menu.js
 * Menu Javascript
 *************************************
 */
class MenuHandler {
    constructor() {
        this.clickHandle = document.querySelectorAll("nav a, nav span");
        this.htmlTag = document.querySelector("html");
        this.breadCrumbLevel1 = document.getElementsByClassName("breadCrumbLevel1")[0];
        this.responsiveNavHolder = document.getElementsByClassName("responsiveNavHolder")[0];
        this.init();
    }
    init() {
        // a / span click
        for (let i = 0; i < this.clickHandle.length; i++) {
            this.clickHandle[i].addEventListener("click", (e) => {
                this.clickFocusHandler(e);
            });
        }
        // breadCrumbLevel1 click
        if (this.breadCrumbLevel1) {
            this.breadCrumbLevel1.addEventListener("click", (e) => {
                let current = document.getElementsByClassName("currentSub");
                this.removeClass(current);
                this.setBreadCrumbLevel1Class();
            });
            this.setBreadCrumbLevel1Class();
        }
        // tab handler
        document.addEventListener("keyup", (e) => {
            if (e.code == "Tab" && e.target.closest("nav")) {
                this.clickFocusHandler(e);
            }
        });
        // remove
        document.addEventListener("focusin", (e) => {
            if (!e.target.closest("nav")) {
                let current = document.getElementsByClassName("currentSub");
                this.removeClass(current);
                if (this.breadCrumbLevel1) {
                    this.setBreadCrumbLevel1Class();
                }
            }
        });
        this.update();
    }
    clickFocusHandler(e) {
        let target = e.target;
        let parentHasChild = target.parentElement.classList.contains("hasChild");
        // disable click when either is true:
        // is desktop touch device
        // is not touch device but in responsive mode
        if ((this.htmlTag.classList.contains("touch") && parentHasChild && e.type == "click") || (this.htmlTag.classList.contains("no-touch") && parentHasChild && this.isResponsive() == true)) {
            e.preventDefault();
        }
        this.clickHandler(target);
    }
    clickHandler(target) {
        let parentLi = target.parentElement;
        let childrenLi = parentLi.getElementsByClassName("currentSub");
        if (childrenLi.length) {
            this.removeClass(childrenLi);
            /* close itself if simple menu */
            if (!layerMoreThanLevel2 || (!this.htmlTag.className.match(/Onion/) && !this.htmlTag.className.match(/Breadcrumbs/))) {
                parentLi.classList.remove("currentSub");
            }
        } else {
            // close all siblings
            this.removeClass(parentLi.parentElement.children, parentLi);
            // toggle self
            if (parentLi.classList.contains("hasChild")) {
                parentLi.classList.toggle("currentSub");
            }
        }
        if (this.breadCrumbLevel1) {
            this.setBreadCrumbLevel1Class();
        }
    }
    removeClass(elements, exclude = null) {
        for (let i = 0; i < elements.length; i++) {
            if (!elements[i].isEqualNode(exclude)) {
                elements[i].classList.remove("currentSub");
            }
        }
    }
    isResponsive() {
        return window.innerWidth <= breakpoint - 1 ? true : false;
    }
    setBreadCrumbLevel1Class() {
        let current = document.querySelector("nav > ul > li.currentSub");
        if (this.breadCrumbLevel1 && current) {
            this.breadCrumbLevel1.classList.add("show");
            this.breadCrumbLevel1.classList.remove("hide");
        } else {
            this.breadCrumbLevel1.classList.remove("show");
            this.breadCrumbLevel1.classList.add("hide");
        }
    }
    setLayerMinHeight() {
        let menu_main = document.getElementsByClassName("menu_main")[0];
        let menuUls = document.querySelectorAll(".menu_main > ul ul");
        let responsiveNavHolderHeight = this.responsiveNavHolder?.dataset?.origHeight;
        // set base height with multiple fallbacks
        if (!responsiveNavHolderHeight) {
            if (this.responsiveNavHolder.scrollHeight > document.querySelector('body').scrollHeight) {
                responsiveNavHolderHeight = this.responsiveNavHolder.scrollHeight || 0;
            } else {
                responsiveNavHolderHeight = document.querySelector('body').scrollHeight;
            }
            this.responsiveNavHolder.dataset.origHeight = responsiveNavHolderHeight;
        }
        let newUlHeight = 0;
        let oldUlHeight = 0;
        // for every navigation mode with Layer
        for (let i = 0; i < menuUls.length; i++) {
            menuUls[i].style.height = "auto";
            let fullOuterHeight = this.outerHeight(menuUls[i]) + parseInt(getComputedStyle(menuUls[i]).top);
            if (fullOuterHeight > oldUlHeight) {
                newUlHeight = fullOuterHeight;
            }
            oldUlHeight = newUlHeight;
        }
        if (newUlHeight < responsiveNavHolderHeight) {
            newUlHeight = responsiveNavHolderHeight;
        }
        if (!menu_main.classList.contains("noCalc") && this.isResponsive()) {
            if (!this.htmlTag.classList.contains("rnTopToBottom")) {
                for (let i = 0; i < menuUls.length; i++) {
                    menuUls[i].style.height = newUlHeight + "px";
                }
            } else {
                for (let i = 0; i < menuUls.length; i++) {
                    menuUls[i].style.height = newUlHeight + "px";
                    menuUls[i].style.top = (newUlHeight + 20) * -1 + "px";
                }
            }
        }
    }
    outerHeight(element) {
        return element.offsetHeight + parseInt(getComputedStyle(element).marginTop) + parseInt(getComputedStyle(element).marginBottom);
    }
    setFixHeaderMargin() {
        if (this.htmlTag.className.match(/FixHeader/)) {
            let templateHeader = document.getElementsByClassName("templateHeader")[0];
            if (this.isResponsive() || this.htmlTag.classList.contains("bBoth")) {
                this.responsiveNavHolder.style.borderTop = this.outerHeight(templateHeader) + "px solid transparent";
            } else {
                this.responsiveNavHolder.style.borderTop = "0px solid transparent";
            }
        }
    }
    update() {
        if (this.htmlTag.className.match(/Onion/) || this.htmlTag.className.match(/Breadcrumbs/)) {
            this.setLayerMinHeight();
        }
        if (this.htmlTag.className.match(/FixHeader/)) {
            this.setFixHeaderMargin();
        }
    }
}
const menus = new MenuHandler();
smartresize(function () {
    menus.update();
});
