<?php

namespace Ig\IgMenu\ViewHelpers;

use Ig\IgMenu\DataProcessing\PagesProcessor;
use Ig\IgMenu\Source\DataProcessorInterface;
use Ig\IgMenu\Utility\SettingsUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/**
 * AubmenuViewHelper
 */
class SubmenuViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('page', 'mixed', 'Seite -> Submenu besteht aus Unterseiten', false, null);
        //$this->registerArgument('databasePage', 'mixed', 'Seite -> Submenu besteht aus Unterseiten', false, null);
        $this->registerArgument('item', 'mixed', 'Item from Database', false, null);
    }

    public function render(): string
    {
        $children = null;
        $hasChildren = false;
        $liClass = '';
        $partialLinkNew = null;
        $templateVariables = [];
        $menuConfig = GeneralUtility::makeInstance(SettingsUtility::class);
        $partialLinkCurrent = $menuConfig->getPartialLink();
        $currentDataProcessing = $menuConfig->getCurrentDataProcessing();
        $templateVariables['currentPartialLink'] = $partialLinkCurrent;
        // Ist maxLevel erreicht
        $level = $menuConfig->getLevel();
        $templateVariables['menu'] = $menuConfig->getMenuProperties();
        if ($level < $menuConfig->getArgument('maxLevel')) {
            // Wurde eine Seite uebergeben und hat diese Unterseiten
            $page = $this->arguments['page'] ?? $this->arguments['item'];
            if (is_object($page)) {
                $source = $page->getIgMenuSource() ?? $currentDataProcessing;
                if ($source == '16') {
                    $obj = GeneralUtility::makeInstance(PagesProcessor::class);
                    $children = $obj->getChildren($page);
                    $partialLinkNew = 'OnePager';
                    $templateVariables['onePagerPage'] = $page;
                    $templateVariables['liClass'] = 'onepage';
                    $templateVariables['liId'] = 'onepage-section-id-';
                } elseif ($source == '101') {
                    // @deprecated
                    //$templateVariables['databasePage'] = $page;
                    $partialLinkNew = 'Database';
                } elseif ($source == '' || $source == '0') {
                    $partialLinkNew = 'Page';
                    $obj = GeneralUtility::makeInstance(PagesProcessor::class);
                    if ($page->getIgMenuLayout() == 1) {
                        // allow sysfolders for spalten pages layout
                        $doktypes = $obj->getDoktypesInMenu();
                        $obj->addDoktypesInMenu([254]);
                        $children = $obj->getChildren($page);
                        $obj->setDoktypesInMenu($doktypes);
                        //$obj->removeDoktypesInMenu([254]);
                    } else {
                        $children = $obj->getChildren($page);
                    }
                } else {
                    //$templateVariables['databasePage'] = $page;
                    $partialLinkNew = 'Default';
                    $obj = GeneralUtility::makeInstance($source);
                    if ($obj instanceof DataProcessorInterface) {
                        if ($currentDataProcessing == $source) {
                            $children = $obj->getChildren($page);
                        } else {
                            $menuConfig->addDataProcessing($source);
                            $menuConfig->setCurrentDataProcessing($source);
                            $children = $obj->process($page);
                        }
                    } else {
                        die('object ' . $obj::class . ' missing interface \Ig\IgMenu\ContentObject\DataProcessorInterface');
                    }
                }

                if (count($children) > 0) {
                    $hasChildren = true;
                    $menuConfig->setLevel($level + 1);
                    //echo( 'Page ' .  $page->getUid() . ': '. $page->getIgMenuSource() .','. $page->getIgMenuLayout() .'<br />');

                    $menuConfig->setPartialLink($partialLinkNew); // ist das noetig???
                    $templateVariables['partialReplacementLink'] = $partialLinkCurrent;
                    $templateVariables['partialLink'] = $partialLinkNew;
                    $templateVariables['children'] = $children;
                }
            }
        }

        $templateVariables['hasChildren'] = $hasChildren;

        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        foreach ($templateVariables as $name => $value) {
            $templateVariableContainer->add($name, $value);
        }

        $content = $this->renderChildren();
        if ($templateVariables !== []) {
            foreach ($templateVariables as $name => $value) {
                $templateVariableContainer->remove($name);
            }
        }

        $menuConfig->setCurrentDataProcessing($currentDataProcessing);
        $menuConfig->setPartialLink($partialLinkCurrent);
        $menuConfig->setLevel($level);
        return $content;
    }
}
