<?php

namespace Ig\IgMenu\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/**
 * ColViewHelper
 */
class ColClassViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments(): void
    {
        $this->registerArgument('cols', 'int', 'Menu Cols', true);
        $this->registerArgument('width', 'int', 'width in Cols', false, 1);
        $this->registerArgument('prefix', 'string', 'prefix', false, 'ym-g');
    }



    public function render(): string
    {
        if ($this->arguments['cols'] <= 0) {
            return '';
        }

        $width = (int) $this->arguments['width'];
        if ($width <= 0) {
            $width = 1;
        }

        return $this->arguments['prefix'] . floor(100 * $width / $this->arguments['cols'] + 0.1);
    }
}
