<?php
namespace Internetgalerie\IgMessages\Controller;

use Internetgalerie\IgMessages\Domain\Repository\MailboxRepository;
use Psr\Http\Message\ResponseInterface;

/**
 * MailboxController
 */
class MailboxController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    /**
     * mailboxRepository
     * 
     * @var MailboxRepository
     */
    protected $mailboxRepository = null;


    /**
     * @param MailboxRepository $mailboxRepository
     */
    public function injectMailboxRepository(MailboxRepository $mailboxRepository)
    {
        $this->mailboxRepository = $mailboxRepository;
    }
    
    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        $mailboxes = $this->mailboxRepository->findAll();
        $this->view->assign('mailboxes', $mailboxes);
        return $this->htmlResponse($this->view->render());
    }
}
