<?php
namespace Internetgalerie\IgMessages\Controller;


use Internetgalerie\IgMessages\Domain\Repository\MessageRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Messaging\AbstractMessage;
use TYPO3\CMS\Extbase\Http\ForwardResponse;

/**
 * MessageController
 */
class MessageController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    /**
     * messageRepository
     * 
     * @var MessageRepository
     */
    protected $messageRepository = null;


    /**
     * @param MessageRepository $messageRepository
     */
    public function injectMessageRepository(MessageRepository $messageRepository)
    {
        $this->messageRepository = $messageRepository;
    }
    
    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        if($this->request->hasArgument('message')) {
            $sendMessage = $this->request->getArgument('message');
        } else {
            $sendMessage =0;
        }
        $messages = $this->messageRepository->findAll();
        $this->view->assign('sendMessage', $sendMessage);
        $this->view->assign('messages', $messages);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action show
     */
    public function showAction(\Internetgalerie\IgMessages\Domain\Model\Message $message): ResponseInterface
    {
        $this->view->assign('message', $message);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action new
     */
    public function newAction(): ResponseInterface
    {
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action create
     * @return void
     */
    public function createAction(\Internetgalerie\IgMessages\Domain\Model\Message $newMessage): ResponseInterface
    {
        $this->addFlashMessage('The object was created. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/typo3cms/extensions/extension_builder/User/Index.html', '', \TYPO3\CMS\Core\Messaging\AbstractMessage::WARNING);
        $this->messageRepository->add($newMessage);
        return $this->redirect('list');
    }

    /**
     * action edit
     * 
     * @param \Internetgalerie\IgMessages\Domain\Model\Message $message
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation $message
     */
    public function editAction(\Internetgalerie\IgMessages\Domain\Model\Message $message): ResponseInterface
    {
        $this->view->assign('message', $message);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action update
     */
    public function updateAction(\Internetgalerie\IgMessages\Domain\Model\Message $message): ResponseInterface
    {
        $this->addFlashMessage('The object was updated. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/typo3cms/extensions/extension_builder/User/Index.html', '', \TYPO3\CMS\Core\Messaging\AbstractMessage::WARNING);
        $this->messageRepository->update($message);
        return $this->redirect('list');
    }

    /**
     * action delete
     */
    public function deleteAction(\Internetgalerie\IgMessages\Domain\Model\Message $message): ResponseInterface
    {
        $this->addFlashMessage('The object was deleted. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/typo3cms/extensions/extension_builder/User/Index.html', '', \TYPO3\CMS\Core\Messaging\AbstractMessage::WARNING);
        $this->messageRepository->remove($message);
        return $this->redirect('list');
    }
    
    /**
     * action send
     * 
     * @param \Internetgalerie\IgMessages\Domain\Model\Message $message
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation $message
     */
    public function sendAction(\Internetgalerie\IgMessages\Domain\Model\Message $message): ResponseInterface
    {
        $messageUid = $message->getUid();
        $countSend=0;
        $countFound=0;
        foreach($message->getUsers() as $user) {
            $values=[
                'pid' => '2000',
                'message' => $messageUid,
                'frontend_user' => $user['uid'],
            ];
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable( 'tx_igmessages_domain_model_mailbox' );
            $res = $queryBuilder
                 ->select('uid')
                 ->from('tx_igmessages_domain_model_mailbox')
                 ->where(
                     $queryBuilder->expr()->eq(
                         'message',
                         $queryBuilder->createNamedParameter($messageUid, \PDO::PARAM_INT)
                     ),
                     $queryBuilder->expr()->eq(
                         'frontend_user',
                         $queryBuilder->createNamedParameter($user['uid'], \PDO::PARAM_INT)
                     )
                 )->executeQuery();
            if($res->fetchAssociative()) {
                $countFound++;
            } else {
                $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable( 'tx_igmessages_domain_model_mailbox' );
                $affectedRows = $queryBuilder->insert( 'tx_igmessages_domain_model_mailbox' )->values( $values )->execute();
                $countSend++;
            }
        }
        //echo("INSERT INTO tx_igmessages_domain_model_mailbox (pid,message,frontend_user) VALUES(2000,1,1313);");

        
        $this->view->assign('message', $message);
        $this->view->assign('count', [
            'send' => $countSend,
            'found' => $countFound
        ]);
        $message->setSendDate(new \DateTime());
        $this->messageRepository->update($message);
        $this->addFlashMessage($countFound . ' Benutzer hatten die Meldung schon', 'Meldung wurde an '.$countSend.' Benutzer verschickt.', AbstractMessage::INFO);

        return new ForwardResponse('list');
    }
}
