<?php
namespace Internetgalerie\IgMessages\Domain\Model;

use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser;
use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUserGroup;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
/**
 * Message
 */
class Message extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    protected string $partial = '';
    protected string $title = '';
    protected string $titleFr = '';
    protected string $body = '';
    protected string $bodyFr = '';
    protected bool $isSend = false;

    /**
     * sendDate
     * 
     * @var \DateTime
     */
    protected $sendDate = null;

    /**
     * frontendUser
     * 
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<FrontendUser>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Lazy
     */
    protected $frontendUser = null;

    /**
     * frontendUserGroup
     * 
     * @var int
     */
    protected $frontendUserGroup = null;

    /**
     * tags
     * 
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Internetgalerie\IgMessages\Domain\Model\Tag>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Lazy
     */
    protected $tags = null;

    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     * 
     * @return void
     */
    protected function initStorageObjects()
    {
        $this->frontendUser = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->tags = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }
    
    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $title): void
    {
        $this->title = $title;
    }

    public function getTitleLang(): string
    {
        return $GLOBALS['TSFE']->lang =='fr' ? $this->titleFr : $this->title;
    }

    public function getTitleFr(): string
    {
        return $this->titleFr;
    }

    public function setTitleFr(string $titleFr): void
    {
        $this->titleFr = $titleFr;
    }
    
    public function getBody(): string
    {
        return $this->body;
    }

    public function getBodyLang(): string
    {
        return $GLOBALS['TSFE']->lang =='fr' ? $this->bodyFr : $this->body;
    }

    public function setBody(string $body): void
    {
        $this->body = $body;
    }

    public function getBodyFr(): string
    {
        return $this->bodyFr;
    }

    public function setBodyFr(string $bodyFr): void
    {
        $this->bodyFr = $bodyFr;
    }

    public function getIsSend(): bool
    {
        return $this->isSend;
    }

    public function setIsSend(bool $isSend): void
    {
        $this->isSend = $isSend;
    }

    public function isIsSend(): bool
    {
        return $this->isSend;
    }

    /**
     * Returns the sendDate
     * 
     * @return \DateTime $sendDate
     */
    public function getSendDate()
    {
        return $this->sendDate;
    }

    /**
     * Sets the sendDate
     * 
     * @param \DateTime $sendDate
     * @return void
     */
    public function setSendDate(\DateTime $sendDate)
    {
        $this->sendDate = $sendDate;
    }


    /**
     * Adds a FrontendUser
     * 
     * @param FrontendUser $frontendUser
     * @return void
     */
    public function addFrontendUser(FrontendUser $frontendUser)
    {
        $this->frontendUser->attach($frontendUser);
    }

    /**
     * Removes a FrontendUser
     * 
     * @param FrontendUser $frontendUserToRemove The FrontendUser to be removed
     * @return void
     */
    public function removeFrontendUser(FrontendUser $frontendUserToRemove)
    {
        $this->frontendUser->detach($frontendUserToRemove);
    }

    /**
     * Returns the frontendUser
     * 
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<FrontendUser> $frontendUser
     */
    public function getFrontendUser()
    {
        return $this->frontendUser;
    }

    /**
     * Sets the frontendUser
     * 
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<FrontendUser> $frontendUser
     * @return void
     */
    public function setFrontendUser(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $frontendUser)
    {
        $this->frontendUser = $frontendUser;
    }

    /**
     * Returns the frontendUserGroup
     * 
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<FrontendUserGroup> $frontendUserGroup
     */
    public function getFrontendUserGroup()
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igmessages_message_frontendusergroup_mm');
        $result = $queryBuilder
                ->select('uid_foreign')
                ->from('tx_igmessages_message_frontendusergroup_mm')
                ->where(
                    $queryBuilder->expr()->eq(
                        'uid_local',
                        $queryBuilder->createNamedParameter($this->uid, \PDO::PARAM_INT)
                    )
                )
                ->executeQuery();
        $data=[];
        while($row=$result->fetchAssociative()) {
            $data[]=['uid' => $row['uid_foreign']];
        }
        return $data;
        //return $result->fetchAll();
    }

    /**
     * Sets the frontendUserGroup
     * 
     * @param array $frontendUserGroupUids
     * @return void
     */
    public function setFrontendUserGroup(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $frontendUserGroup)
    {
        //$this->frontendUserGroup = $frontendUserGroup;
    }

    public function getPartial(): string
    {
        return $this->partial;
    }

    public function setPartial(string $partial): void
    {
        $this->partial = $partial;
    }

    /**
     * Adds a Tag
     * 
     * @param \Internetgalerie\IgMessages\Domain\Model\Tag $tag
     * @return void
     */
    public function addTag(\Internetgalerie\IgMessages\Domain\Model\Tag $tag)
    {
        $this->tags->attach($tag);
    }

    /**
     * Removes a Tag
     * 
     * @param \Internetgalerie\IgMessages\Domain\Model\Tag $tagToRemove The Tag to be removed
     * @return void
     */
    public function removeTag(\Internetgalerie\IgMessages\Domain\Model\Tag $tagToRemove)
    {
        $this->tags->detach($tagToRemove);
    }

    /**
     * Returns the tags
     * 
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Internetgalerie\IgMessages\Domain\Model\Tag> $tags
     */
    public function getTags()
    {
        return $this->tags;
    }

    /**
     * Sets the tags
     * 
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Internetgalerie\IgMessages\Domain\Model\Tag> $tags
     * @return void
     */
    public function setTags(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $tags): void
    {
        $this->tags = $tags;
    }
    public function getUsers(): array
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('fe_users');
        $result = $queryBuilder
                ->select('*')
                ->from('fe_users')
                ->executeQuery();
        $tagValues = [];
        foreach($this->tags as $tag) {
            $tagValues[] = $tag->getValue();
        }
        //$tagValues=['81005'];
        $frontendUserGroups = [];
        foreach($this->getFrontendUserGroup() as $frontendUserGroup) {
            $frontendUserGroups[]=$frontendUserGroup['uid'];
        }
        $data = [];
        while($row=$result->fetchAssociative()) {
            if(!$this->hasNumber($row['cnum'], $tagValues)) {
                continue;
            }
            
            if(!$this->inUsergroup($row['usergroup'], $frontendUserGroups)) {
                continue;
            }
            //var_dump($tagValues, $usergroup,$writeNumbders,$row );            exit(0);
            //echo($row['username']. ' ' .  $row['uid']  . '<br />');
            $data[]=[
                'uid' => $row['uid'],
                'username' => $row['username'],
                'cnum' => $row['cnum'],
            ];
        }
        return $data;
    }
    // Hat Benutzer Rechte auf angegebene Betriebe
    public function hasNumber(?string $cnum, array $tagValues): bool
    {
        if(empty($tagValues)) {
                return true;
        }
        if($cnum===null) {
            return false;
        }
        $writeNumbders =  explode(',', $cnum);
        foreach($writeNumbders as $writeNumbder) {
            foreach($tagValues as $tagValue) {
                $length = strlen($tagValue);
                $compare = substr($writeNumbder, 0, $length);
                if($compare == $tagValue) {
                    return true;
                }
            }
            /*
            $compare = substr($writeNumbder,0,1);
            if(in_array($compare, $tagValues)) {
                return true;
            }
            */
        }
        return false;
    }
    public function getUsersNotSend(): array
    {
        $usersNotSend = [];
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable( 'tx_igmessages_domain_model_mailbox' );
        foreach($this->getUsers() as $user) {
            $res = $queryBuilder
                 ->select('uid')
                 ->from('tx_igmessages_domain_model_mailbox')
                 ->where(
                     $queryBuilder->expr()->eq(
                         'message',
                         $queryBuilder->createNamedParameter($this->uid, \PDO::PARAM_INT)
                     ),
                     $queryBuilder->expr()->eq(
                         'frontend_user',
                         $queryBuilder->createNamedParameter($user['uid'], \PDO::PARAM_INT)
                     )
                 )->executeQuery();
            if($res->fetchAssociative()) {
                continue;
            }
            $usersNotSend[] = $user;
        }

        return $usersNotSend;
    }
    // Ist Benutzer in einer der angegebenen Gruppen
    public function inUsergroup(string $usergroup, array $frontendUserGroups ): bool
    {
        if(empty($frontendUserGroups)) {
                return true;
        }
        $userGroups = explode(',' , $usergroup);
        foreach($userGroups as $userGroup) {
        if(in_array($userGroup, $frontendUserGroups)) {
                return true;
            }
        }
        return false;
    }
    public function getMails(): int
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igmessages_domain_model_mailbox');
        $result = $queryBuilder
                ->addSelectLiteral(
                    $queryBuilder->expr()->count('uid', 'anzahl')
                )
                //->select('count(1) AS anzahl')
                ->from('tx_igmessages_domain_model_mailbox')
                 ->where(
                     $queryBuilder->expr()->eq(
                         'message',
                         $queryBuilder->createNamedParameter($this->getUid(), \PDO::PARAM_INT)
                     )
                 )
                ->executeQuery();
        $row = $result->fetchAssociative();
        return (int)$row['anzahl'];
    }
    public function getMailsNew(): int
    {
        return $this->getMailsIsNew(1);
    }
    public function getMailsRead(): int
    {
        return $this->getMailsIsNew(0);
    }
    public function getMailsIsNew($isNew): int
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igmessages_domain_model_mailbox');
        $result = $queryBuilder
                ->addSelectLiteral(
                    $queryBuilder->expr()->count('uid', 'anzahl')
                )
                //->select('count(1) AS anzahl')
                ->from('tx_igmessages_domain_model_mailbox')
                 ->where(
                     $queryBuilder->expr()->eq(
                         'message',
                         $queryBuilder->createNamedParameter($this->getUid(), \PDO::PARAM_INT)
                     ),
                     $queryBuilder->expr()->eq(
                         'is_new',
                         $queryBuilder->createNamedParameter($isNew, \PDO::PARAM_INT)
                     )
                 )
                ->executeQuery();
        $row = $result->fetchAssociative();
        return (int)$row['anzahl'];
    }

    public function getMailsDone(): int
    {
        return $this->getMailsIsDone(1);
    }
    public function getMailsIsDone($isDone): int
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igmessages_domain_model_mailbox');
        $result = $queryBuilder
                ->addSelectLiteral(
                    $queryBuilder->expr()->count('uid', 'anzahl')
                )
                //->select('count(1) AS anzahl')
                ->from('tx_igmessages_domain_model_mailbox')
                 ->where(
                     $queryBuilder->expr()->eq(
                         'message',
                         $queryBuilder->createNamedParameter($this->getUid(), \PDO::PARAM_INT)
                     ),
                     $queryBuilder->expr()->eq(
                         'is_done',
                         $queryBuilder->createNamedParameter($isDone, \PDO::PARAM_INT)
                     )
                 )
                ->executeQuery();
        $row = $result->fetchAssociative();
        return (int)$row['anzahl'];
    }
}
