<?php
declare(strict_types = 1);
namespace Ig\IgMountpoint\LinkHandler;

use TYPO3\CMS\Core\Database\Query\Restriction\DeletedRestriction;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Backend\LinkHandler\PageLinkHandler;
use TYPO3\CMS\Backend\Utility\BackendUtility;
use TYPO3\CMS\Core\Site\SiteFinder;

use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\Query\Restriction\WorkspaceRestriction;
use TYPO3\CMS\Core\LinkHandling\LinkService;
use TYPO3\CMS\Core\Utility\MathUtility;
use TYPO3\CMS\Core\Imaging\Icon;


/**
 * Link handler pages of mountpoints
 */
class MountpointLinkHandler extends PageLinkHandler
{
    /**
     * Configuration key in TSconfig TCEMAIN.linkHandler.record
     *
     * @var string
     */
    protected $identifier;

    /**
     * Specific TSconfig for the current instance (corresponds to TCEMAIN.linkHandler.record.identifier.configuration)
     *
     * @var array
     */
    protected $configuration = [];

    /**
     * Parts of the current link
     *
     * @var array
     */
    protected $linkParts = [];

    /**
     * @var int
     */
    protected $expandPage = 0;


    public $queryMP = null;

    public $mp = null;

    protected $mountPid = null;

    protected $mpUid = null;

    protected $finder = null;

    /**
     * Checks if this is the right handler for the given link.
     *
     * Also stores information locally about currently linked record.
     *
     * @param array $linkParts Link parts as returned from TypoLinkCodecService
     * @return bool
     */
    public function canHandleLink(array $linkParts): bool
    {
        if( !isset($linkParts['url']['parameters']) ) {
            return false;
        }
        $parameters = $linkParts['url']['parameters'];
        if(!str_starts_with((string) $parameters, 'MP=')) {
            return false;
        }
        return parent::canHandleLink( $linkParts );
    }

    /**
     * Formats information for the current record for HTML output.
     *
     * @return string
     */
    public function formatCurrentUrl(): string
    {
        return parent::formatCurrentUrl() . ' ('.$this->linkParts['url']['parameters'].')';
    }

    /**
     * Renders the link handler.
     *
     * @param ServerRequestInterface $request
     * @return string
     */
    public function render(ServerRequestInterface $request): string
    {
        $this->pageRenderer->loadJavaScriptModule('@typo3/backend/page-link-handler.js');
        $this->pageRenderer->loadJavaScriptModule('@typo3/backend/viewport/resizable-navigation.js');
        $this->pageRenderer->loadJavaScriptModule('@internetgalerie/igmountpoint/tree/page-browser.js');
        
        $this->getBackendUser()->initializeWebmountsForElementBrowser();

        $this->expandPage = isset($request->getQueryParams()['expandPage']) ? (int)$request->getQueryParams()['expandPage'] : 0;

        $this->view->assign('initialNavigationWidth', $this->getBackendUser()->uc['selector']['navigation']['width'] ?? 250);
        //$this->view->assign('treeActions', ['link']);

        
        if (isset($request->getQueryParams()['query_MP'])) {
            $this->queryMP = $request->getQueryParams()['query_MP'];
            $mps=explode('-',substr((string) $this->queryMP,3));
            $this->mountPid=(int)$mps[0];
            $this->mpUid=(int)$mps[1];
        } else if( isset($this->linkParts['url']['parameters'])) {
            $parameters=$this->linkParts['url']['parameters'];
            if(str_starts_with((string) $parameters, 'MP=')) {
                $this->queryMP = $parameters;
                $this->mp = substr((string) $this->linkParts['url']['parameters'],3);
                $mps = explode('-', substr((string) $parameters,3));
                $this->mountPid = (int)($mps[0] ?? 0);
                $this->mpUid = (int)($mps[1] ?? 0);
            }
        }
        //var_dump($request->getQueryParams()['P']['currentValue'], substr($this->linkParts['url']['parameters'],3));exit(0);
        // Define the current page
        if (isset($request->getQueryParams()['expandPage'])) {
            $this->expandPage = (int)$request->getQueryParams()['expandPage'];
        } elseif (isset($this->configuration['storagePid'])) {
            $this->expandPage = (int)$this->configuration['storagePid'];
        } elseif (isset($this->linkParts['pid'])) {
            $this->expandPage = (int)$this->linkParts['pid'];
        }
        //        $this->setTemporaryDbMounts();
        if (isset($request->getQueryParams()['P'])) {
            $P=$request->getQueryParams()['P'];
            $currentPageUid = $P['pid'];
            $this->finder=GeneralUtility::makeInstance(SiteFinder::class);
            $site = $this->finder->getSiteByPageId((int)$currentPageUid);
            //$currentSite=GeneralUtility::makeInstance(SiteMatcher::class)->matchByPageId((int)$currentPageUid);

            $title = $site->getBase()->getHost();
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable( 'pages' );
            $queryBuilder
                ->getRestrictions()
                ->removeAll()
                ->add(GeneralUtility::makeInstance(DeletedRestriction::class));
            $res = $queryBuilder
                 ->select('uid', 'pid', 'mount_pid', 'title')
                 ->from('pages')
                 ->where(
                     $queryBuilder->expr()->neq( 'mount_pid', $queryBuilder->createNamedParameter(0, Connection::PARAM_INT)),
                     $queryBuilder->expr()->eq( 'pid', $queryBuilder->createNamedParameter((int)$site->getRootPageId(), Connection::PARAM_INT)),
                     $queryBuilder->expr()->eq( 'sys_language_uid', $queryBuilder->createNamedParameter(0, Connection::PARAM_INT))
                 )
                 ->executeQuery();
            $data = [];
            while ($row = $res->fetchAssociative()) {
                //$row['link']=GeneralUtility::linkThisScript(['query_MP' => 'MP=' . $row['mount_pid'] . '-' . $row['uid']]);
                $row['mp'] =$row['mount_pid'] . '-' . $row['uid'];
                $row['active']=$row['uid']==$this->mpUid;
                $data[] = $row;
            }
            //$title='Mountpoints';
            $mountpointDomains[$title] = $data; 
        }


        $path = GeneralUtility::getFileAbsFileName('EXT:ig_mountpoint/Resources/Private/Templates/LinkBrowser/Mountpoint.html');
        //$this->view->setTemplatePathAndFilename($path);
        
        //$view = GeneralUtility::makeInstance(StandaloneView::class);
        //$view->setTemplatePathAndFilename($path);

        if (isset($request->getQueryParams()['MP'])) {
            $this->mp = $request->getQueryParams()['MP'];
        }

        $this->view->assignMultiple([
            //'tree' => $this->mpUid ? $this->renderPageTree() : '',
            'mountpointDomains' =>  $mountpointDomains,
            'mp' => $this->mp,
        ]);
        $entryPoint = (int)$this->mp;
        if ($entryPoint) {
            $this->view->assign('entryPoint', $entryPoint);
        }
        $this->getRecordsOnExpandedPage($this->expandPage);
        //$activePageRecord = BackendUtility::getRecordWSOL('pages', $pageId);
        //$this->view->assign('activePage', $activePageRecord);
        $this->view->assign('treeActions', ['link']);
        $this->view->setTemplateRootPaths([GeneralUtility::getFileAbsFileName('EXT:ig_mountpoint/Resources/Private/Templates/LinkBrowser')]);
        $this->view->setTemplate('Mountpoint');
        return '';
        return $this->view->render();
        return $view->render();
    }

    /**
     * This adds all content elements on a page to the view and lets you create a link to the element.
     *
     * @param int $pageId Page uid to expand
     */
    protected function getRecordsOnExpandedPage($pageId)
    {
        // If there is an anchor value (content element reference) in the element reference, then force an ID to expand:
        if (!$pageId && isset($this->linkParts['url']['fragment'])) {
            // Set to the current link page id.
            $pageId = $this->linkParts['url']['pageuid'];
        }
        $linkService = GeneralUtility::makeInstance(LinkService::class);
        $this->view->assign('expandedPage', $pageId ?: $this->linkParts['url']['pageuid'] ?? 0);
        // Draw the record list IF there is a page id to expand:
        if ($pageId && MathUtility::canBeInterpretedAsInteger($pageId) && $this->getBackendUser()->isInWebMount($pageId)) {
            $pageId = (int)$pageId;

            $activePageRecord = BackendUtility::getRecordWSOL('pages', $pageId);
            $this->view->assign('expandActivePage', true);

            // Create header for listing, showing the page title/icon
            $this->view->assign('activePage', $activePageRecord);
            $this->view->assign('activePageTitle', BackendUtility::getRecordTitle('pages', $activePageRecord, true));
            $this->view->assign('activePageIcon', $this->iconFactory->getIconForRecord('pages', $activePageRecord, Icon::SIZE_SMALL)->render());
            if ($this->isPageLinkable($activePageRecord)) {
                //$this->view->assign('activePageLink', $linkService->asString(['type' => LinkService::TYPE_PAGE, 'pageuid' => $pageId, 'MP' => $this->mp]));
                $this->view->assign('activePageLink', 't3://page?uid=' . (int)$pageId . ($this->mp ? '&MP=' . $this->mp : ''));
            }

            // Look up tt_content elements from the expanded page
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)
                          ->getQueryBuilderForTable('tt_content');

            $queryBuilder->getRestrictions()
                ->removeAll()
                ->add(GeneralUtility::makeInstance(DeletedRestriction::class))
                ->add(GeneralUtility::makeInstance(WorkspaceRestriction::class, (int)$this->getBackendUser()->workspace));

            $contentElements = $queryBuilder
                             ->select('*')
                             ->from('tt_content')
                             ->where(
                                 $queryBuilder->expr()->and(
                                     $queryBuilder->expr()->eq('pid', $queryBuilder->createNamedParameter($pageId, Connection::PARAM_INT)),
                                     $queryBuilder->expr()->in('sys_language_uid', $queryBuilder->createNamedParameter([$activePageRecord['sys_language_uid'], -1], Connection::PARAM_INT_ARRAY))
                                 )
                             )
                             ->orderBy('colPos')
                             ->addOrderBy('sorting')
                             ->executeQuery()
                             ->fetchAllAssociative();

            //$this->view->assign('activePageLink', $linkService->asString(['type' => LinkService::TYPE_PAGE, 'pageuid' => $pageId]) .'&MP=' . $this->mp);

            // Enrich list of records
            foreach ($contentElements as &$contentElement) {
                BackendUtility::workspaceOL('tt_content', $contentElement);
                //$contentElement['url'] = $linkService->asString(['type' => LinkService::TYPE_PAGE, 'pageuid' => $pageId, 'MP' => $this->mp, 'fragment' => $contentElement['uid']]);
                $contentElement['url'] = 't3://page?uid=' . (int)$pageId . ($this->mp ? '&MP=' . $this->mp : '') . '#' . $contentElement['uid'];
                
                $contentElement['isSelected'] = (int)($this->linkParts['url']['fragment'] ?? 0) === (int)$contentElement['uid'];
                $contentElement['icon'] = $this->iconFactory->getIconForRecord('tt_content', $contentElement, Icon::SIZE_SMALL)->render();
                $contentElement['title'] = BackendUtility::getRecordTitle('tt_content', $contentElement, true);
            }
            $this->view->assign('contentElements', $contentElements);
        }
    }

    /**
     * @return string[] Array of body-tag attributes
     */
    public function getBodyTagAttributes()
    {
        if (count($this->linkParts) === 0 || empty($this->linkParts['url']['pageuid'])) {
            return [];
        }
        $pageId = (int)$this->linkParts['url']['pageuid'];
        $fragment = ($this->linkParts['url']['fragment'] ?? false) ? '#' . $this->linkParts['url']['fragment'] : '';
        return [
            'data-current-link' => 't3://page?uid=' . $pageId . ($this->mp ? '&MP=' . $this->mp : '') . $fragment
        ];
    }

    
}
