<?php

namespace Ig\IgNewsletter\Utility;

use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManager;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;

class SetupUtility implements SingletonInterface
{
    //current values
    private $width = null;
    private $outerWidth = null;
    private $depth = 0;
    private $layout = '0';
    private $frameClass = 'default';
    private $totalNumberOfCols = 1;
    private $config = '';
    private $colsTdStyles = [];
    private $currentCol = 0;
    private $colWidth = 100;
    private $settings = [];
    private $styles = [];

    public function __construct()
    {
        $configurationManager = GeneralUtility::makeInstance(ConfigurationManager::class);
        $settings = $configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS,
            'IgNewsletter',
            'ig_newsletter'
        );
        $this->settings = $settings;
        $this->width = (int)($settings['pageWidth'] ?? 590); // Initial Width
        $this->outerWidth = $this->width;
    }
    public function setLayoutConfig($layout, $config)
    {
        if ($layout == '' || $layout === null) {
            $layout = $this->layout;
        } else {
            $this->layout = $layout;
        }
        if (!$config) {
            $config = '0';
        }
        $this->config = $config;
        if (!isset($this->settings['layout'][$layout])) {
            // if we  an admin user is logged in or debug is on -> show an error message if no typoscript is present
            // Check if a backend user exists and is an admin
            $backendUser = $GLOBALS['BE_USER'] ?? null;
            $isAdmin = $backendUser instanceof BackendUserAuthentication && $backendUser->isAdmin();

            // Check if debug mode is enabled in settings
            $isDebug = $this->settings['debug'] ?? false;


            return ($isAdmin || $isDebug) ? 'ERROR: layout "plugin.tx_ignewsletter.settings.layout.' . $layout . '" not defined in typoscript' : '';
        }

        return '';
    }
    public function setLayout($layout)
    {
        return $this->layout = $layout;
    }
    public function getLayout()
    {
        return $this->layout;
    }
    public function setFrameClass($frameClass)
    {
        return $this->frameClass = $frameClass;
    }
    public function getFrameClass()
    {
        return $this->frameClass;
    }
    public function getConfig()
    {
        return $this->config;
    }
    public function setTotalNumberOfCols($totalNumberOfCols)
    {
        $this->totalNumberOfCols = $totalNumberOfCols;
    }
    public function getTotalNumberOfCols()
    {
        return $this->totalNumberOfCols;
    }
    // CALCUALTE TABLE - with paddings
    public function startTable()
    {
        $this->outerWidth = $this->width;
        $this->width += $this->getAddBefore();
        $this->depth++;
        $this->colsTdStyles = $this->getCssSettingForCols($this->totalNumberOfCols, $this->layout, $this->config, 'td');
        $this->width -= $this->colsTdStyles['sum'];
    }
    public function startRow()
    {
        $this->currentCol = 0;
    }
    public function startCol($currentColWidth, $currentCol = null)
    {
        if ($currentCol === null) {
            $currentCol = $this->currentCol;
        }

        $this->setCols($this->totalNumberOfCols, $currentColWidth);
        $this->currentCol = $currentCol;

        $currentColTdStyle = $this->colsTdStyles['cols'][$this->currentCol] ?? [];
        $this->outerWidth = $this->width - $this->getAddAfter() + ($currentColTdStyle['padding-left'] ?? 0) + ($currentColTdStyle['padding-right'] ?? 0);

        return $this->debug($currentColWidth);
    }
    public function startBox($config = 'innerBox')
    {
        $this->config = $config;
        $this->colsTdStyles = $this->getCssSettingForCols($this->totalNumberOfCols, $this->layout, $this->config, 'td');
        $this->outerWidth = $this->width;
        $this->width -= $this->colsTdStyles['sum'];
    }
    public function debug($title = '')
    {
        if (!isset($this->settings['debug']) || !intval($this->settings['debug'])) {
            return '';
        }
        $ret = '<b>' . $title . '</b> ';
        $ret .= 'frame_class="' . $this->frameClass . '", layout="' . $this->layout . '" class="' . $this->config . '": width=' . $this->width . '(lr:' . $this->getPaddingLeftRight() . ')=' . $this->getOuterWidth();
        if ($this->getAddBefore() != 0) {
            $ret .= ', addBefore: ' . $this->getAddBefore();
        }
        if ($this->totalNumberOfCols >= 1) {
            $ret .= ', totalNumberOfCols=' . $this->totalNumberOfCols . '(currentCol:' . $this->currentCol . ')';
        }
        if ($this->getColWidth() > 0) {
            $ret .= ', currentColWidth: ' . $this->getColWidth();
        }
        if ($this->getAddAfter() != 0) {
            $ret .= ', addAfter: ' . $this->getAddAfter();
        }
        $ret .= ', style="' . $this->getStyle();
        if ($this->colsTdStyles['sum'] > 0) {
            $ret .= ', sumPaddings=' . $this->colsTdStyles['sum'];
        }
        return '<div style="color: red;font-size: 8px;">' . $ret . '</div>';
    }


    public function setCurrentCol($currentCol)
    {
        $this->currentCol = $currentCol;
    }
    public function increaseCurrentCol()
    {
        $this->currentCol++;
    }
    public function getCurrentCol()
    {
        return $this->currentCol;
    }
    public function setWidth($width)
    {
        $this->width = $width;
    }
    public function getDepth()
    {
        return $this->depth;
    }
    public function getWidth()
    {
        return $this->width;
    }
    public function setColWidth($colWidth)
    {
        $this->colWidth = $colWidth;
    }
    public function getColWidth()
    {
        return $this->colWidth;
    }

    public function getAddBefore(): int
    {
        return (int)($this->settings['layout'][$this->layout][$this->config]['addBefore'] ?? 0);
    }

    public function getAddAfter(): int
    {
        return (int)($this->settings['layout'][$this->layout][$this->config]['addAfter'] ?? 0);
    }

    public function getPaddingLeftRight()
    {
        $currentColTdStyle = $this->colsTdStyles['cols'][$this->currentCol];
        return ($currentColTdStyle['padding-left'] ?? 0) + ($currentColTdStyle['padding-right'] ?? 0);
    }
    public function getOuterWidth()
    {
        return $this->outerWidth;
        //$currentColTdStyle=$this->colsTdStyles['cols'][$this->currentCol] ?? [];
        //return $this->width-$this->getAddAfter()+($currentColTdStyle['padding-left'] ?? 0)+ ($currentColTdStyle['padding-right'] ?? 0);
    }
    public function setCols($totalNumberOfCols, $currentColWidth)
    {
        if ($currentColWidth > 0) {
            $this->width = intval($this->width * $currentColWidth / 100);
        } else {
            $this->width = intval($this->width / $totalNumberOfCols);
        }
    }



    /*
    public function setStyles( $styles )
    {
        $this->styles=$styles;
    }
    public function addStyle( $name, $style )
    {
        $this->styles[$name]=$style;
    }
    */
    /*
    public function getStyles( )
    {
        if(!isset($this->styles['td'])) {
            $this->styles['td']='';
        }
        foreach($this->currentColTdStyle as $attribute=>$value) {
            $this->styles['td'].=' ' . $attribute.': '.$value.'px;';
        }
        return $this->styles;
    }
     */
    /*
    public function getStyle( $name )
    {
        $names=explode('.',$name);
        $name=$names[0];
        if(count($names)>1) {
            $valueName=$names[1];
            if(isset($this->styles[$name][$valueName])) {
                //var_dump($this->styles[$name][$valueName]);            die($name .'....'. $valueName);
                return $this->styles[$name][$valueName];
            }
        }
        $valueName='_typoScriptNodeValue';
        if(isset($this->styles[$name][$valueName])) {
            return $this->styles[$name][$valueName];
        }
        return isset($this->styles[$name]) && is_string($this->styles[$name]) ? $this->styles[$name] : '';
    }
    */
    public function getCurrent()
    {
        return [
            'width' => $this->width,
            'outerWidth' => $this->outerWidth,
            'depth' => $this->depth,
            'layout' => $this->layout,
            'frameClass' => $this->frameClass,
            'config' => $this->config,
            'totalNumberOfCols' => $this->totalNumberOfCols,
            'colsTdStyles' => $this->colsTdStyles,

            'currentCol' => $this->currentCol,
            'colWidth' => $this->colWidth,
        ];
    }
    public function setCurrent($current)
    {
        $this->width = $current['width'];
        $this->outerWidth = $current['outerWidth'];
        $this->depth = $current['depth'];
        $this->layout = $current['layout'];
        $this->frameClass = $current['frameClass'];
        $this->totalNumberOfCols = $current['totalNumberOfCols'];
        $this->config = $current['config'];
        $this->colsTdStyles = $current['colsTdStyles'];

        $this->colWidth = $current['colWidth'];
        $this->currentCol = $current['currentCol'];
    }


    public function getCssSettingForCols($totalNumberOfCols, $layout, $config, $element = 'td')
    {
        $defaultStyle = $this->getCssSetting($this->settings['layout'][$layout][$config][$element] ?? []);
        $colsTdStyles = [];
        for ($colIndex = 0;$colIndex < $totalNumberOfCols;$colIndex++) {
            $currentStyles = $defaultStyle;
            if ($colIndex == 0) {
                $currentStyles = array_merge(
                    $currentStyles,
                    $this->getCssSetting($this->settings['layout'][$layout][$config][$element . '-first'] ?? [])
                );
            }
            if ($colIndex == $totalNumberOfCols - 1) {
                $currentStyles = array_merge(
                    $currentStyles,
                    $this->getCssSetting($this->settings['layout'][$layout][$config][$element . '-last'] ?? [])
                );
            }
            $colsTdStyles[] = $currentStyles;
        }
        $sum = $this->getPaddingFromCols($colsTdStyles);
        return [
            'sum' => $sum,
            'cols' => $colsTdStyles,
        ];
        //return $colsTdStyles;
    }

    public function getPaddingFromCols($colsTdStyles)
    {
        $sum = 0;
        foreach ($colsTdStyles as $td) {
            $sum += ($td['padding-left'] ?? 0) + ($td['padding-right'] ?? 0);
        }
        return $sum;
    }
    public function setStyleFromColsTdStyles($currentColTdStyles)
    {
        foreach ($currentColTdStyles as $name => $currentColTdStyle) {
            foreach ($currentColTdStyle as $attribute => $value) {
                $this->styles[$name] = '';
                $this->styles[$name] .= ' ' . $attribute . ': ' . $value . 'px;';
            }
        }
    }
    public function getStyle()
    {
        $styles = '';
        //var_dump($this->colsTdStyles['cols']);
        if (!empty($this->colsTdStyles['cols'][$this->currentCol])) {
            foreach ($this->colsTdStyles['cols'][$this->currentCol] as $attribute => $value) {
                $styles .= ' ' . $attribute . ': ' . $value . 'px;';
            }
        }
        return $styles;
    }
    public function getOuterBox($responsive, $class = '')
    {
        $classOuterBox = 'nl_outer_box nl_outer_box_' . $this->totalNumberOfCols . ' ' . ($responsive ? 'nl_outer_box_responsive' : 'nl_outer_box_fix');
        return [
            'begin' => '<table width="' . $this->getOuterWidth() . '" class="' . $classOuterBox . ' frame-' . $this->frameClass . ' frame-layout-' . $this->layout . ($this->config ? ' ' . $this->config : '') . ($class ? ' ' . $class : '') . '" align="center" cellspacing="0" cellpadding="0" border="0" style="border-collapse:collapse; margin:0 auto; mso-table-lspace:0; mso-table-rspace:0; width:' . $this->getOuterWidth() . 'px; max-width:' . $this->getOuterWidth() . 'px; margin: 0 auto;"><tbody>',
            'end' => '</tbody></table>',
        ];
    }

    public function getOuterBoxTd($colspan = 1, $additionalClass = '')
    {
        if ($this->currentCol == 0) {
            if ($this->totalNumberOfCols == 1) {
                $classOuterClass = 'nl_outer_box_td_first nl_outer_box_td_last nl_outer_box_td_first-last';
            } else {
                $classOuterClass = 'nl_outer_box_td_first';
            }
        } elseif ($this->currentCol == $this->totalNumberOfCols - 1) {
            $classOuterClass = 'nl_outer_box_td_last';
        } else {
            $classOuterClass = 'nl_outer_box_td_middle';
        }
        if ($colspan > 1) {
            $htmlColspan = ' colspan="' . $colspan . '"';
            if ($this->totalNumberOfCols == $colspan) {
                $this->totalNumberOfCols = 1;
                $this->setTotalNumberOfCols($this->totalNumberOfCols);
            }
        } else {
            $htmlColspan = '';
        }

        return '<td border="0" cellpadding="0" cellspacing="0" class="nl_outer_box_td  nl_outer_box_' . $this->totalNumberOfCols . '_td nl_outer_box_td_' . $this->currentCol . ' ' . $classOuterClass . ($additionalClass ? ' ' . $additionalClass : '') . '" style="border-collapse:collapse; mso-table-lspace:0; mso-table-rspace:0; vertical-align: top;' . $this->getStyle(
            'td'
        ) . '"' . $htmlColspan . '>';
    }

    public function getOuterBoxIfNeeded($layout, $frameClass)
    {
        if ($this->depth > 0) {
            return [
                'begin' => '',
                'end' => '',
            ];
        }
        $this->setTotalNumberOfCols(1);
        $this->setLayoutConfig($layout, 'outerBox');
        $this->setFrameClass($frameClass);
        $this->startTable();
        $contentArray = $this->getOuterBox(true);
        $contentArray['begin'] .= '<tr>' . $this->getOuterBoxTd();
        $contentArray['end'] = '</td></tr>' . $contentArray['end'];
        return $contentArray;
    }
    public function getInnerBox($layout, $align = 'left')
    {
        if (!$layout) {
            $layout = '0';
        }
        if ($this->currentCol == 0) {
            if ($this->totalNumberOfCols == 1) {
                $classInnerBoxTd = 'nl_inner_box_td_first nl_inner_box_td_last nl_inner_box_td_first-last';
            } else {
                $classInnerBoxTd = 'nl_inner_box_td_first';
            }
        } elseif ($this->currentCol == $this->totalNumberOfCols - 1) {
            $classInnerBoxTd = 'nl_inner_box_td_last';
        } else {
            $classInnerBoxTd = 'nl_inner_box_td_middle';
        }
        $innerWidth = $this->getWidth();
        $outerWidth = $this->getOuterWidth();

        $htmlClass = 'ym-g' . intval($this->getColWidth());
        $content = '<table align="center" width="' . $outerWidth . '" border="0" cellpadding="0" cellspacing="0" class="frame-' . $this->frameClass . ' frame-layout-' . $layout . ' nl_inner_box ' . $htmlClass . '" style="border-collapse:collapse; margin:0 auto; mso-table-lspace:0; mso-table-rspace:0;width:' . $outerWidth . 'px;max-width:' . $outerWidth . 'px;margin:0;">
                    <tbody>
                      <tr>
                        <td align="' . $align . '" class="nl_inner_box_td nl_inner_box_td_' . $this->currentCol . ' ' . $classInnerBoxTd . '" style="border-collapse:collapse; margin:0; text-align: ' . $align . '; vertical-align: top;' . $this->getStyle(
            'td'
        ) . '" valign="top">';

        return [
            'begin' => $content,
            'end' => '</td></tr></tbody></table>',
        ];
    }
    private function getCssSetting($array)
    {
        $styles = [];
        foreach ($array as $attribute => $value) {
            $styles[$attribute] = intval($value);
        }
        return $styles;
    }
}
