<?php

namespace Ig\IgNewsletter\ViewHelpers\Grid;

use Ig\IgNewsletter\Utility\SetupUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ColViewHelper extends AbstractViewHelper
{
    /**
     * @var boolean
     */
    protected $escapeOutput = false;
    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        $this->registerArgument('col', 'mixed', 'current column number of row', false);
        $this->registerArgument('colspan', 'int', 'colspan vom td', false, '1');
        $this->registerArgument('width', 'mixed', 'Col Width in %', false, '0');
        $this->registerArgument('align', 'text', 'align left/right', false, 'left');
        $this->registerArgument('class', 'string', 'Additional CSS Classes', false, '');
    }

    public function render(): string
    {
        return static::renderStatic(
            $this->arguments,
            $this->buildRenderChildrenClosure(),
            $this->renderingContext,
        );
    }

    /**
     * @return \Ig\IgResponsiveImages\Domain\Model\Page
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $setupUtility = GeneralUtility::makeInstance(SetupUtility::class);
        $current = $setupUtility->getCurrent();

        $totalNumberOfCols = $setupUtility->getTotalNumberOfCols();
        $layout = $setupUtility->getLayout();
        if (isset($arguments['col'])) {
            $setupUtility->setCurrentCol(intval($arguments['col']));
        }
        $col = $setupUtility->getCurrentCol();
        $colWidth = $arguments['width'];
        $setupUtility->setColWidth($colWidth);
        $colspan = intval($arguments['colspan']);
        $content = $setupUtility->getOuterBoxTd($colspan, $arguments['class']) . $setupUtility->debug();
        /*
        $align=$arguments['align'];
        $debugOutput=$setupUtility->startBox('innerBox');
        $debugOutput.=$setupUtility->startCol($colWidth, $col);
        $contentArray=$setupUtility->getInnerBox( $colWidth, $align);
        $content.=$contentArray['begin'] . $debugOutput;
        */
        //TODO set responsive images width - mittels Hook
        // 			  <ri:setup cols="3" class="3-spalten-nl" tagWidth="{nl:width(width: 100)}">
        
        $content .= $renderChildrenClosure();
        //TODO reset responsive images width - mittels Hook
        /*
        if( $totalNumberOfCols>1 ) {
            $responsiveImageUtility->popWidth();
        }
        */
        //$content .= $contentArray['end'] . '</td>';
        $content .= '</td>';
        $setupUtility->setCurrent($current);
        $setupUtility->setCurrentCol($col + $colspan);
        return $content;
    }
}
