<?php

namespace Ig\IgNewsletter\ViewHelpers;

use Ig\IgNewsletter\Utility\SetupUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class GridViewHelper extends AbstractViewHelper
{
    /**
     * @var boolean
     */
    protected $escapeOutput = false;
    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        $this->registerArgument('cols', 'mixed', 'Number of cols', false, 1);
        $this->registerArgument('width', 'string', 'width in Pixel', false);
        $this->registerArgument('layout', 'mixed', 'Layout/Configuration Name', false);
        $this->registerArgument('frameClass', 'mixed', 'Class/Configuration Name', false);
        //$this->registerArgument('config', 'mixed', 'Configuration Name', false, '');
        $this->registerArgument('class', 'mixed', 'Class/Configuration Name', false, '');
        $this->registerArgument('responsive', 'boolean', 'responsive otherwise fix', false, true);
    }

    public function render(): string
    {
        return static::renderStatic(
            $this->arguments,
            $this->buildRenderChildrenClosure(),
            $this->renderingContext,
        );
    }
    
    /**
     * @return \Ig\IgResponsiveImages\Domain\Model\Page
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $setupUtility = GeneralUtility::makeInstance(SetupUtility::class);
        $current = $setupUtility->getCurrent();
        if (isset($arguments['width'])) {
            $setupUtility->setWidth(intval($arguments['width']));
        }
        $debugOutput = '';
        $setupUtility->setTotalNumberOfCols($arguments['cols']);
        if (isset($arguments['layout'])) {
            //echo('layout='.$arguments['layout'].'<br />');
            $debugOutput .= $setupUtility->setLayoutConfig($arguments['layout'], 'outerBox');
        }
        if (isset($arguments['frameClass'])) {
            $setupUtility->setFrameClass($arguments['frameClass']);
        }
        $debugOutput .= $setupUtility->startTable();

        $contentArray = $setupUtility->getOuterBox($arguments['responsive'], $arguments['class']);
        $content = $contentArray['begin'] . $renderChildrenClosure() . $contentArray['end'];
        $setupUtility->setCurrent($current);
        return $debugOutput . $content;
    }
}
