<?php

namespace Ig\IgNewsletter\ViewHelpers;

use Pelago\Emogrifier\CssInliner;
use Pelago\Emogrifier\HtmlProcessor\CssToAttributeConverter;
use Pelago\Emogrifier\HtmlProcessor\HtmlNormalizer;
use Pelago\Emogrifier\HtmlProcessor\HtmlPruner;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

//suse WebentwicklerAt\Emogrifier\Utility\EmogrifierUtility;

class InlineCssViewHelper extends AbstractViewHelper
{
    /**
     * @var boolean
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('src', 'string', 'CSS filename', false);
        $this->registerArgument('style', 'string', 'CSS as a string.', false);
    }

    /**
     * @return string
     */
    public function render()
    {
        $content = $this->renderChildren();
        $css = '';
        if (isset($this->arguments['style'])) {
            $css .= $this->arguments['style'];
        }
        if (isset($this->arguments['src'])) {
            $src = GeneralUtility::getFileAbsFileName($this->arguments['src']);
            if (file_exists($src)) {
                $css .= file_get_contents($src);
            }
        }

        if ($css == '') {
            return $content;
        }
  
        $extractContent = true;
        $normalizedHtml = HtmlNormalizer::fromHtml($content)->render();
        $domDocument = CssInliner::fromHtml($normalizedHtml)->inlineCss($css)->getDomDocument();

        HtmlPruner::fromDomDocument($domDocument)->removeElementsWithDisplayNone();
        $html = CssToAttributeConverter::fromDomDocument($domDocument)
        ->convertCssToVisualAttributes()
->renderBodyContent();


        return $html;
    
        //return EmogrifierUtility::emogrify($content, $css, $extractContent);
    }
}
