<?php

namespace Ig\IgNewsletter\ViewHelpers;

use Ig\IgNewsletter\Utility\SetupUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class BoxViewHelper extends AbstractViewHelper
{
    /**
     * @var boolean
     */
    protected $escapeOutput = false;
    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        $this->registerArgument(
            'cType',
            'mixed',
            'CType, if present do not draw any boxes if it is a gridelements_pi1',
            false,
            ''
        );
        $this->registerArgument('galleryPosition', 'mixed', 'gallery.position, position of the image/text', false, []);
        $this->registerArgument('layout', 'mixed', 'Class/Configuration Name', false);
        $this->registerArgument('frameClass', 'mixed', 'Class/Configuration Name', false);
    }


    public function render(): string
    {
        return static::renderStatic(
            $this->arguments,
            $this->buildRenderChildrenClosure(),
            $this->renderingContext,
        );
    }
    /**
     * @return \Ig\IgResponsiveImages\Domain\Model\Page
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        if ($arguments['cType'] == 'gridelements_pi1') {
            return $renderChildrenClosure();
        }
        $galleryPosition = $arguments['galleryPosition'];
        $setupUtility = GeneralUtility::makeInstance(SetupUtility::class);
        $begin = '';
        $end = '';
        $current = $setupUtility->getCurrent();
        if ($setupUtility->getDepth() == 0) {
            if ($arguments['cType'] == 'textmedia' && $galleryPosition['vertical'] == 'intext') {
                return $renderChildrenClosure();
            }
            $setupUtility->setTotalNumberOfCols(1);
            $contentArray = $setupUtility->getOuterBoxIfNeeded($arguments['layout'], $arguments['frameClass']);
            $begin = $contentArray['begin'];
            $end = $contentArray['end'];
        }
        /*
        if( $arguments['cType']=='textmedia') {
            $content= $renderChildrenClosure();
            $setupUtility->setCurrent( $current );
            return $begin . $content . $end;
            }*/
        $col = $setupUtility->getCurrentCol();
        $debugOutput = $setupUtility->startBox('innerBox');
        $debugOutput .= $setupUtility->startCol($setupUtility->getColWidth(), $col);
        $contentArray = $setupUtility->getInnerBox($arguments['layout']);
        $begin .= $contentArray['begin'] . $setupUtility->debug('Auto-Box');
        $end = $contentArray['end'] . $end;

        $totalNumberOfCols = $setupUtility->getTotalNumberOfCols();
        if ($totalNumberOfCols >= 1) {
            $responsiveImageUtility = GeneralUtility::makeInstance(
                \Ig\IgResponsiveImages\Utility\ResponsiveImagesUtility::class
            );
            $responsiveImageUtility->pushCols($totalNumberOfCols . '-spalten-nl');
            $responsiveImageUtility->setTagWidth($setupUtility->getWidth());
        }

        $content = $renderChildrenClosure();
        if ($totalNumberOfCols >= 1) {
            $responsiveImageUtility->popWidth();
        }

        $setupUtility->setCurrent($current);
        return $begin . $content . $end;
    }
}
