<?php

namespace Ig\IgNewsletter\ViewHelpers\Grid;

use Ig\IgNewsletter\Utility\SetupUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class RowViewHelper extends AbstractViewHelper
{
    /**
     * @var boolean
     */
    protected $escapeOutput = false;


    public function render(): string
    {
        return static::renderStatic(
            $this->arguments,
            $this->buildRenderChildrenClosure(),
            $this->renderingContext,
        );
    }

    /**
     * @return \Ig\IgResponsiveImages\Domain\Model\Page
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $setupUtility = GeneralUtility::makeInstance(SetupUtility::class);
        $setupUtility->startRow();
        $content = $renderChildrenClosure();
        return '<tr>' . $content . '</tr>';
    }
}
