<?php

namespace Ig\IgNewsletter\ViewHelpers;

use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class PreheaderViewHelper extends AbstractViewHelper
{
    /**
     * @var boolean
     */
    protected $escapeOutput = false;


    public function render(): string
    {
        return static::renderStatic(
            $this->arguments,
            $this->buildRenderChildrenClosure(),
            $this->renderingContext,
        );
    }

    /**
     * @return \Ig\IgResponsiveImages\Domain\Model\Page
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $abstract = trim($renderChildrenClosure());
        if ($abstract) {
            return '<div style="height:0px; font-size:0px; max-height:0px; min-height: 0px; line-height:0px; width: 100%; color: #fff; display:none;">' . $abstract . '</div>';
        }
        return '';
    }
}
