<?php

namespace Ig\IgNewsletter\ViewHelpers;

use Ig\IgNewsletter\Utility\SetupUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\ViewHelpers\ForViewHelper;

class SetupViewHelper extends ForViewHelper
{
    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        $this->registerArgument('config', 'mixed', 'Configuration Name', false, 'default');
        $this->registerArgument('layout', 'mixed', 'Class/Configuration Name', false, '0');
        $this->registerArgument('frameClass', 'mixed', 'Class/Configuration Name', false, 'default');
        $this->registerArgument('width', 'string', 'width in Pixel or %', false);
        $this->registerArgument('cols', 'mixed', 'Number of cols', false, 1);
        $this->registerArgument('col', 'int', 'current col', false, 0);
        $this->registerArgument('colWidth', 'mixed', 'Width of cols in pixel', false, null);
    }
    public function render(): string
    {
        return static::renderStatic(
            $this->arguments,
            $this->buildRenderChildrenClosure(),
            $this->renderingContext,
        );
    }
    
    /**
     * @return \Ig\IgResponsiveImages\Domain\Model\Page
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $debugOutput = '';
        $setupUtility = GeneralUtility::makeInstance(SetupUtility::class);
        // backup current values
        $current = $setupUtility->getCurrent();
        if (isset($arguments['width'])) {
            $setupUtility->setWidth(intval($arguments['width']));
        }
        //if( isset($arguments['layout'])) {
        $setupUtility->setTotalNumberOfCols($arguments['cols']);
        $debugOutput = $setupUtility->setLayoutConfig($arguments['layout'], $arguments['config']);
        $debugOutput .= $setupUtility->startTable();
        $debugOutput .= $setupUtility->setCol($arguments['colWidth'], $arguments['col']);

        //}
        $output = $debugOutput . $renderChildrenClosure();
        // restore Values
        $setupUtility->setCurrent($current);
        return $output;
    }
}
