<?php

namespace Ig\IgNewsletter\Controller;

use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Query\QueryBuilder;
use TYPO3\CMS\Core\Domain\Repository\PageRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;

use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class ContentController extends ActionController
{
    private ?QueryBuilder $queryBuilder;

    public function showAction(): ResponseInterface
    {
        $pid = $this->request->getAttribute('frontend.page.information')->getId();
        $headerLinks = $this->getContentHeaderLinks($pid);
        $this->view->assign('headerLinks', $headerLinks);

        return $this->htmlResponse();
    }
    
    protected function initializeAction(): void
    {
        $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tt_content');
        $this->queryBuilder = $connection->createQueryBuilder();
    }

    private function getContentByPid(int $pid, int $container = 0): array
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $languageId = $context->getPropertyFromAspect('language', 'id');
        $this->queryBuilder->select('*')
                           ->from('tt_content')
                           ->where(
                               $this->queryBuilder->expr()
->eq('pid', (int)$pid),
                               $this->queryBuilder->expr()
->eq('tx_container_parent', (int)$container),
                               $this->queryBuilder->expr()
->neq('goToTop', 1),
                               $this->queryBuilder->expr()
->neq('header_layout', 100),
                               $this->queryBuilder->expr()
->in('sys_language_uid', [0, -1]),
                           );
        $this->queryBuilder->orderBy($GLOBALS['TCA']['tt_content']['ctrl']['sortby']);
        $result = $this->queryBuilder->executeQuery();
        $records = $result->fetchAllAssociative();

        // @do overlays
        return $this->applyLanguageOverlays($records, $languageId);
    }


    private function applyLanguageOverlays(array $records, int $languageId): array
    {
        $pageRepository = GeneralUtility::makeInstance(PageRepository::class);
        if ($languageId > 0) {
            foreach ($records as &$record) {
                // Apply language overlay for each record
                $record = $pageRepository->getRecordOverlay(
                    'tt_content',
                    $record,
                    $languageId
                );
            }
        }
        return $records;
    }
    
    private function getContentHeaderLinks(int $pid): string
    {
        $rows = $this->getContentByPid($pid);

        return '<ul class="igcontenttopics-ul">' . $this->getContentHeaderLinksByRows($rows, 0) . '</ul>';
    }

    private function getContentHeaderLinksByRows(array $rows, int $deep = 0): string
    {
        $result = '';
        $li_is_open = false;

        foreach ($rows as $row) {
            if (trim($row['header']) != '') {
                $result .= ($li_is_open ? '</li>' : '') . '<li class="contenttopics-li"><a class="contenttopics-link" href="#c' . $row['uid'] . '">' . $row['header'] . '</a>';
                $li_is_open = true;
            }
            $children = $this->getContentByPid($row['pid'], $row['uid']);
            //echo('<h2>'. $row['uid'].'</h2>');var_dump($children);
            if (!empty($children)) {
                if (!$li_is_open) {
                    $result .= $this->getContentHeaderLinksByRows($children);
                } else {
                    $result .= ($li_is_open ? '' : '<li class="contenttopics-li">') . '<ul style="margin-left:25px;">' . $this->getContentHeaderLinksByRows(
                        $children
                    ) . '</ul></li>';
                }
                $li_is_open = false;
            }
        }
        return $result . ($li_is_open ? '</li>' : '');
    }
}
