<?php

declare(strict_types=1);

namespace Ig\IgNewsletter\Updates;

use TYPO3\CMS\Install\Updates\AbstractListTypeToCTypeUpdate;
use TYPO3\CMS\Install\Attribute\UpgradeWizard;

#[UpgradeWizard('igNewsletterCTypeMigration')]
final class IgNewsletterCTypeMigration extends AbstractListTypeToCTypeUpdate
{
    protected function getListTypeToCTypeMapping(): array
    {
        return ['ignewsletter_igcontenttopics' => 'ignewsletter_igcontenttopics'];
    }

    public function getTitle(): string
    {
        return 'Migrate "Ig Newsletter" plugins to content elements.';
    }

    public function getDescription(): string
    {
        return 'The "Ig Newsletter" plugin is now registered as content element. Update migrates existing records and backend user permissions.';
    }

}