<?php

namespace Ig\IgNewsletter\ViewHelpers;

use Ig\IgNewsletter\Utility\SetupUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class OuterWidthViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper
{
    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        $this->registerArgument('width', 'double', 'Width in %', false, 100);
        $this->registerArgument('addBefore', 'double', 'Add px to pageWidth before %', false, 0);
        $this->registerArgument('addAfter', 'double', 'Add px after %', false, 0);
    }


    public function render()
    {
        $setupUtility = GeneralUtility::makeInstance(SetupUtility::class);
        $pageWidth = $setupUtility->getOuterWidth();

        //$width= round(($pageWidth+intval($this->arguments['addBefore']))*intval($this->arguments['width'])/100)+intval($this->arguments['addAfter']);
        $width = floor(($pageWidth + intval($this->arguments['addBefore'])) * intval($this->arguments['width']) / 100) + intval(
            $this->arguments['addAfter']
        );
        return $width;
    }
}
