<?php

namespace Ig\IgPayment\Services;

use Ig\IgPayment\Domain\Model\PaymentStatus;
use TYPO3\CMS\Core\SingletonInterface;

abstract class PaymentService implements SingletonInterface
{
    protected string $code;
    protected string $externalId = '';
    protected array $assigns = [];
    protected array $products = [];
    protected array $shipping = [];
    protected array $shippingAddress = [];
    protected array $billingAddress = [];

    public abstract function updatePayment($orderId, $currency, $amount, $reference, $redirectUrl, $failUrl = '', $paymentMethodCode = ''): PaymentStatus;
    public abstract function invokePayment($orderId, $currency, $amount, &$reference, $redirectUrl, $failUrl = ''): PaymentStatus;
    public abstract function checkTransactionSuccess($currency, $amount): PaymentStatus;
    
    public function clear(string $checkoutReference): bool
    {
        return true;
    }

    public function setExternalId(string $externalId)
    {
        $this->externalId = $externalId;
    }

    public function getExternalId(): mixed
    {
        return $this->externalId;
    }

    public function setAssigns(array $assigns = []): void
    {
        $this->assigns = $assigns;
    }

    public function getAssigns(): array
    {
        return $this->assigns;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setProducts(array $products)
    {
        $this->products = $products;
    }

    public function setShipping(array $shipping)
    {
        $this->shipping = $shipping;
    }

    public function setShippingAddress(array $shippingAddress)
    {
        $this->shippingAddress = $shippingAddress;
    }

    public function setBillingAddress(array $billingAddress)
    {
        $this->billingAddress = $billingAddress;
    }
    
}