<?php
namespace Ig\IgPayment\ViewHelpers\Form;

use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

//require_once ExtensionManagementUtility::extPath('ig_payment') . 'Resources/Private/Php/braintree-php-5.1.0/lib/autoload.php';
//require_once ExtensionManagementUtility::extPath('ig_payment') . 'Resources/Private/Php/braintree-php-3.23.1/lib/autoload.php';


class BraintreeViewHelper extends AbstractTagBasedViewHelper
{
    protected ConfigurationManagerInterface $configurationManager;

    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager)
    {
        $this->configurationManager = $configurationManager;
    }

    /**
     * Returns TypoSript settings array
     *
     * @param string $extension Name of the extension
     * @param string $plugin Name of the plugin
     * @return array
     */
    public function getSettings($extension, $plugin)
    {
        $typoScript = $this->configurationManager->getConfiguration(
            \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS,
            $extension,
            $plugin
        );

        return $typoScript;
    }

    public function initializeArguments()
    {
        $typoscript= $this->configurationManager->getConfiguration(\TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
        $settings=$typoscript['plugin.']['tx_igpayment.']['settings.']['braintree.'];
        $braintreeEnvironment = $settings['environment'];
        \Braintree\Configuration::environment($braintreeEnvironment);

        \Braintree\Configuration::merchantId($settings[$braintreeEnvironment . '.']['merchantId'] ? : $settings['merchantId']);
        \Braintree\Configuration::publicKey($settings[$braintreeEnvironment . '.']['publicKey'] ? : $settings['publicKey']);
        \Braintree\Configuration::privateKey($settings[$braintreeEnvironment . '.']['privateKey'] ? : $settings['privateKey']);
        /*
          $this->registerUniversalTagAttributes();
          $this->registerTagAttribute('name', 'string', 'Specifies the name of an anchor');
          $this->registerTagAttribute('rel', 'string', 'Specifies the relationship between the current document and the linked document');
          $this->registerTagAttribute('rev', 'string', 'Specifies the relationship between the linked document and the current document');
          $this->registerTagAttribute('target', 'string', 'Specifies where to open the linked document');
        */
        $this->registerArgument('formId', 'string', 'ID des Formulares', false, 'payment-form');
        $this->registerArgument('formSubmitId', 'string', 'ID des submit Knopfs', false, 'payload-submit');
        $this->registerArgument('dropinId', 'string', 'ID des div für DropIn', false, 'bt-dropin');
        $this->registerArgument('paymentMethodNonceId', 'string', 'Id für hidden Feld Nonce', false, 'paymentMethodNonce');
        $this->registerArgument('locale', 'string', 'Current Locale', false, null);
    }


    
    /**
     * Render a sortlink
     *
     * @return string
     * @api
     */
    public function render()
    {
        $formId=$this->arguments['formId'];
        $formSubmitId=$this->arguments['formSubmitId'];
        $dropinId=$this->arguments['dropinId'];
        $paymentMethodNonceId=$this->arguments['paymentMethodNonceId'];
        $clientToken=\Braintree\ClientToken::generate();
        //$pageRenderer=GeneralUtility::makeInstance(\TYPO3\CMS\Core\Page\PageRenderer::class);
        // $this->pageRenderer->getLanguage();
      
        $currentLocale = substr(setlocale(LC_MONETARY, 0), 0, 5);
        $locale=$this->arguments['locale'] ?? $currentLocale;
      
        $js=' <script data-ignore="1">
        var client_token = "'. $clientToken .'";

	    braintree.dropin.create(
            {
                authorization: client_token,
                selector: "#' . $dropinId . '",
                locale: "' . $locale . '",
                paypal: {
                    flow: "vault"
                },
        	},
            function(createErr, instance) {
                if(createErr) {
                    console.error(createErr);
                    return;
                }
                var $submitButton = $("#' . $formSubmitId . '");
                $submitButton.click(function(e) {
console.log("test submit");
	                $submitButton.addClass("loading");
                    $submitButton.addClass("disabled");
                    $submitButton.attr("disabled", true);
                    var $paymentMethodNonce = $("#' . $paymentMethodNonceId . '");
console.log("paymentMethodNonce=" + $paymentMethodNonce.val());
                    if($paymentMethodNonce.val() != "") {
console.log("UPS paymentMethodNonce=" + $paymentMethodNonce.val());

                        $("#' . $formId . '").submit();
                    } else {
                        e.preventDefault();
                        instance.requestPaymentMethod(function(requestPaymentMethodErr, payload) {
                            if(requestPaymentMethodErr) {
	                        $submitButton.removeClass("loading");
                                console.error(requestPaymentMethodErr);
                                return;
                            }
                            // To submit the payload nonce to the server we create a new hidden form field which is sent to server on submit
                            /*$("<input />")
                            .attr("type", "hidden")
                            .attr("id", "' . $paymentMethodNonceId . '")
                            .attr("name", "payment_method_nonce")
                            .attr("value", payload.nonce)
                            .appendTo("#' . $formId . '");*/
                           $paymentMethodNonce.val(payload.nonce);
console.log("UPS");
	                       $("#' . $formId . '").submit();
                       });
                    }
                });
                if (instance.isPaymentMethodRequestable()) {
                    $submitButton.removeClass("disabled");
                    $submitButton.removeAttr("disabled");
                }

	// Fromular komplett
                instance.on("paymentMethodRequestable", function (event) {
                    //console.log(event.type);
                    $submitButton.removeClass("disabled");
                    $submitButton.removeAttr("disabled");
                });
            // Formular wieder unvollständig
                instance.on("noPaymentMethodRequestable", function () {
                    $submitButton.addClass("disabled");
                    $submitButton.attr("disabled", true);
                });
            }
        );


    </script>';
        return $js;
    }
}
