<?php
namespace Ig\IgPayment\ViewHelpers\Form;

use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Mvc\ExtbaseRequestParameters;
use TYPO3\CMS\Extbase\Mvc\Request;
use TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder;
use TYPO3\CMS\Fluid\Core\Rendering\RenderingContext;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

class PostFinanceViewHelper extends AbstractTagBasedViewHelper
{
    protected ConfigurationManagerInterface $configurationManager;

    protected UriBuilder $uriBuilder;

    protected $settings = [];

    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager)
    {
        $this->configurationManager = $configurationManager;
    }

    public function injectUriBuilder(UriBuilder $uriBuilder)
    {
        $this->uriBuilder = $uriBuilder;
    }

    public function initializeArguments()
    {
        $typoscript= $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
        $settings=$typoscript['plugin.']['tx_igpayment.']['settings.'];
        $this->settings = ['postfinance' => $settings['postfinance.']];

        
        $this->registerArgument('shaIn', 'string', 'SHA in signature', false, $this->settings['postfinance']['shaIn']);
        $this->registerArgument('hashAlgorithm', 'string', 'Hash algorithm to use', false, $this->settings['postfinance']['hashAlgorithm'] ?? 'sha1');
        $this->registerArgument('url', 'string', 'PostFinance URL', false, $this->settings['postfinance']['test'] ? 'https://e-payment.postfinance.ch/ncol/test/orderstandard.asp' : 'https://e-payment.postfinance.ch/ncol/prod/orderstandard.asp');
        $this->registerArgument('amount', 'string', 'Total amount', true, null);
        $this->registerArgument('currency', 'string', 'Currency', false, 'CHF');
        $this->registerArgument('language', 'string', 'Language Key', false, $this->settings['postfinance']['language'] ?? substr(setlocale(LC_MONETARY, 0), 0, 5));
        $this->registerArgument('orderid', 'string', 'Order UID', true, null);
        $this->registerArgument('pspid', 'string', 'PostFinance ID', false, $this->settings['postfinance']['pspID'] ?? null);
        $this->registerArgument('accepturl', 'string', 'URL called on success', false);
        $this->registerArgument('declineurl', 'string', 'URL called on decline', false);
        $this->registerArgument('exceptionurl', 'string', 'URL called on error', false);
        $this->registerArgument('cancelurl', 'string', 'URL called if user aborts the payment', false);
        $this->registerArgument('complus', 'string', 'Complus value', false, '1');
    }

    /**
     * Render a sortlink
     *
     * @return string
     * @api
     */
    public function render()
    {
        $typoscript = $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
        $settings = $typoscript['plugin.']['tx_igpayment.']['settings.'];
        $this->settings = ['postfinance' => $settings['postfinance.']];
        /** @var RenderingContext $renderingContext */
        $renderingContext = $this->renderingContext;
        $request = $renderingContext->getRequest();
        $extbaseRequest = new Request(
            $request->withAttribute('extbase', new ExtbaseRequestParameters())
        );
        $backUrl = $this->settings['postfinance']['backUrl'] ? $this->uriBuilder->reset()->setRequest($extbaseRequest)->setTargetPageUid($this->settings['postfinance']['backUrl'])->setCreateAbsoluteUri(true)->build() : null;

        $shaIn = $this->arguments['shaIn'];
        $hashAlgorithm = $this->arguments['hashAlgorithm'];
        $url = $this->arguments['url'];
        $amount = $this->arguments['amount'] * 100;
        $currency = $this->arguments['currency'];
        $language=$this->arguments['language'];
        $orderid = $this->arguments['orderid'];
        $pspid = $this->arguments['pspid'];
        $accepturl = $this->arguments['accepturl'] ?? $backUrl;
        $declineurl = $this->arguments['declineurl'] ?? $backUrl;
        $exceptionurl = $this->arguments['exceptionurl'] ?? $backUrl;
        $cancelurl = $this->arguments['cancelurl'] ?? $backUrl;
        $complus = $this->arguments['complus'];

        if (!$shaIn) {
            throw new \InvalidArgumentException('Argument "shaIn" not set in view helper "' . get_class($this) . '"', 1237901529);
        }

        if (!$pspid) {
            throw new \InvalidArgumentException('Argument "pspid" not set in view helper "' . get_class($this) . '"', 1237902529);
        }

        if (!$accepturl) {
            throw new \InvalidArgumentException('Argument "accepturl" not set in view helper "' . get_class($this) . '"', 1237903529);
        }

        if (!$declineurl) {
            throw new \InvalidArgumentException('Argument "declineurl" not set in view helper "' . get_class($this) . '"', 1237904529);
        }

        if (!$exceptionurl) {
            throw new \InvalidArgumentException('Argument "exceptionurl" not set in view helper "' . get_class($this) . '"', 1237905529);
        }

        if (!$cancelurl) {
            throw new \InvalidArgumentException('Argument "cancelurl" not set in view helper "' . get_class($this) . '"', 1237906529);
        }

        $output = '<form class="form-kontakt" action="' . $url . '" method="post">
            <div>
                <input type="hidden" name="AMOUNT"      value="' . $amount . '" />
                <input type="hidden" name="CURRENCY"    value="' . $currency . '" />
                <input type="hidden" name="LANGUAGE"    value="' . $language . '" />
                <input type="hidden" name="ORDERID"     value="' . $orderid . '" />
                <input type="hidden" name="PSPID"       value="' . $pspid . '" />
                <input type="hidden" name="ACCEPTURL" value="' . $accepturl . '">
                <input type="hidden" name="DECLINEURL" value="' . $declineurl . '">
                <input type="hidden" name="EXCEPTIONURL" value="' . $exceptionurl . '">
                <input type="hidden" name="CANCELURL" value="' . $cancelurl . '">
                <input type="hidden" name="COMPLUS" value="' . $complus . '">';

        // Seed for the hash
        $amount = 'AMOUNT=' . $amount . $shaIn;
        $currency = 'CURRENCY=' . $currency . $shaIn;
        $language = 'LANGUAGE=' . $language . $shaIn;
        $orderid = 'ORDERID=' . $orderid . $shaIn;
        $pspid = 'PSPID=' . $pspid . $shaIn;
        $accepturl = 'ACCEPTURL=' . $accepturl . $shaIn;
        $declineurl = 'DECLINEURL=' . $declineurl . $shaIn;
        $exceptionurl = 'EXCEPTIONURL=' . $exceptionurl . $shaIn;
        $cancelurl = 'CANCELURL=' . $cancelurl . $shaIn;
        $complus = 'COMPLUS=' . $complus . $shaIn;

        $hashData = $accepturl.$amount.$cancelurl.$complus.$currency.$declineurl.$exceptionurl.$language.$orderid.$pspid;
        $shasign = strtoupper(hash($hashAlgorithm, $hashData));

        $output .= '<input type="hidden" name="SHASIGN"     value="' . $shasign . '" />
            </div>';

        $output .= $this->renderChildren();

        $output .= '</form>';

        return $output;
    }
}
