<?php

namespace Ig\IgPayment\Domain\Model;

use TYPO3\CMS\Core\Http\RedirectResponse;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class PaymentStatus extends AbstractEntity
{
    const PENDING = 'PENDING';
    const PAID = 'PAID';
    const EXPIRED = 'EXPIRED';
    
    protected string $status = self::PENDING;
    protected bool $transactionSuccess = false;
    protected bool $orderChanged = false;
    protected ?RedirectResponse $redirect = null;

    public function setStatus(string $status): void
    {
        $this->status = $status;
    }

    public function isPaid(): bool
    {
        return $this->status === PaymentStatus::PAID;
    }

    public function isPending(): bool
    {
        return $this->status === PaymentStatus::PENDING;
    }

    public function isExpired(): bool
    {
        return $this->status === PaymentStatus::EXPIRED;
    }

    public function setTransactionSuccess(bool $transactionSuccess): void
    {
        $this->transactionSuccess = $transactionSuccess;
    }

    public function getTransactionSuccess(): bool
    {
        return $this->transactionSuccess;
    }

    public function setOrderChanged(bool $orderChanged): void
    {
        $this->orderChanged = $orderChanged;
    }

    public function getOrderChanged(): bool
    {
        return $this->orderChanged;
    }

    public function setRedirect(RedirectResponse $redirect)
    {
        $this->redirect = $redirect;
    }

    public function getRedirect(): ?RedirectResponse
    {
        return $this->redirect;
    }
}