<?php
namespace Ig\IgPayment\Services;

use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * This calss provides methods for acces checking and authorization
 */

// ugly use autoload
//require_once ExtensionManagementUtility::extPath('ig_payment') . 'Resources/Private/Php/braintree-php-5.1.0/lib/autoload.php';
//require_once ExtensionManagementUtility::extPath('ig_payment') . 'Resources/Private/Php/braintree-php-3.23.1/lib/autoload.php';


class BraintreeService implements \TYPO3\CMS\Core\SingletonInterface
{
    private $result = null;
    
    public function __construct()
    {
        $configurationManager = GeneralUtility::makeInstance(\TYPO3\CMS\Extbase\Configuration\ConfigurationManager::class);
        $typoscript= $configurationManager->getConfiguration(\TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
        $settings=$typoscript['plugin.']['tx_igpayment.']['settings.']['braintree.'];
        //$this->settings = $settings['braintree.'];

        $braintreeEnvironment = $settings['environment'];
        \Braintree\Configuration::environment($braintreeEnvironment);
        \Braintree\Configuration::merchantId($settings[$braintreeEnvironment . '.']['merchantId'] ? : $settings['merchantId']);
        \Braintree\Configuration::publicKey($settings[$braintreeEnvironment . '.']['publicKey'] ? : $settings['publicKey']);
        \Braintree\Configuration::privateKey($settings[$braintreeEnvironment . '.']['privateKey'] ? : $settings['privateKey']);
    }
    
    public function generate()
    {
        return \Braintree\ClientToken::generate();
    }
    public function find($transactionId)
    {
        return \Braintree\Transaction::find($transactionId);
    }

    public function sale(array $conf)
    {
        $result = \Braintree\Transaction::sale($conf);
        $this->result = $result;
        return $result;
    }
    public function getResult()
    {
        return $this->result;
    }

    public function isSuccess()
    {
        return $this->isResultSuccess($this->result);
    }
    public function getErrorMessage()
    {
        $errorString = '';
        
        foreach ($this->result->errors->deepAll() as $error) {
            $errorString .= 'Error: ' . $error->code . ': ' . $error->message . "\n";
        }
        return $errorString;
    }
    
    public function saleAndTest($saleAmount, $amount, $payment_method_nonce)
    {
        //$amount = GeneralUtility::_POST('amount');
        //    $nonce = GeneralUtility::_POST('payment_method_nonce');
        //echo($amount . '==' . $saleAmount .' mit '.$payment_method_nonce.'<br />');
        $this->result = null;
        if ($amount == $saleAmount) {
            $this->result = \Braintree\Transaction::sale([
                'amount' => $amount,
                'paymentMethodNonce' => $payment_method_nonce,
                'options' => [
                    'submitForSettlement' => true
                ]
            ]);
            if ($this->result->success || !is_null($this->result->transaction)) {
                $transaction = $this->result->transaction;
                if ($this->isTransactionSuccessful($transaction)) {
                    // Send signal
                    return true;
                }
            }
        }
        return false;
    }


    public function isResultSuccess($result)
    {
        if ($result===null) {
            return false;
        }
        if ($result->success || !is_null($result->transaction)) {
            $transaction = $result->transaction;
            if ($this->isTransactionSuccessful($transaction)) {
                return true;
            }
        }
        return false;
    }

    
    public function isTransactionSuccessful($transaction)
    {
        $transactionSuccessStatuses = [
            \Braintree\Transaction::AUTHORIZED,
            \Braintree\Transaction::AUTHORIZING,
            \Braintree\Transaction::SETTLED,
            \Braintree\Transaction::SETTLING,
            \Braintree\Transaction::SETTLEMENT_CONFIRMED,
            \Braintree\Transaction::SETTLEMENT_PENDING,
            \Braintree\Transaction::SUBMITTED_FOR_SETTLEMENT
        ];

        if (in_array($transaction->status, $transactionSuccessStatuses)) {
            return true;
        }
        
        return false;
    }
}
