<?php
namespace Ig\IgPayment\Services;

use TYPO3\CMS\Core\Utility\GeneralUtility;

class PostFinanceService implements \TYPO3\CMS\Core\SingletonInterface
{
    private $allowedParameters = array(
               'AAVADDRESS', 'AAVCHECK', 'AAVZIP', 'ACCEPTANCE', 'ALIAS', 'AMOUNT', 'BRAND',
               'CARDNO', 'CCCTY', 'CN', 'COMPLUS', 'CREATION_STATUS', 'CURRENCY', 'CVC', 'CVCCHECK',
               'DCC_COMMPERCENTAGE', 'DCC_CONVAMOUNT', 'DCC_CONVCCY', 'DCC_EXCHRATE', 'DCC_EXCHRATESOURCE',
               'DCC_EXCHRATETS', 'DCC_INDICATOR', 'DCC_MARGINPERCENTAGE', 'DCC_VALIDHOURS',
               'DIGESTCARDNO', 'ECI', 'ED', 'ENCCARDNO', 'IP', 'IPCTY', 'NBREMAILUSAGE',
               'NBRIPUSAGE', 'NBRIPUSAGE_ALLTX', 'NBRUSAGE', 'NCERROR', 'NCERRORCN', 'NCERRORCARDNO', 'NCERRORCVC',
               'NCERRORED','ORDERID', 'PAYID', 'PAYIDSUB', 'PM', 'SCO_CATEGORY', 'SCORING', 'STATUS', 'SUBSCRIPTION_ID',
               'TRXDATE', 'VC',
               );

    protected $vars = [];
    protected $settings = [];

    /**
     * Constructor
     */
    public function __construct()
    {
        $configurationManager = GeneralUtility::makeInstance(\TYPO3\CMS\Extbase\Configuration\ConfigurationManager::class);
        $typoscript = $configurationManager->getConfiguration(\TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
        $settings = $typoscript['plugin.']['tx_igpayment.']['settings.'];
        $this->settings = ['postfinance' => $settings['postfinance.']];

        foreach ($_REQUEST as $key => $var) {
            $k = strtoupper($key);

            if (in_array($k, $this->allowedParameters)) {
                $this->vars[strtoupper($key)] = $var;
            }
        }
    }

    /**
     * Returns the vars array
     *
     * @return $vars
     */
    public function getVars()
    {
        return $this->vars;
    }

    /**
     * Returns a string representing the action to do the redirect
     *
     * @return string
     */
    public function getAction($shaOutSign = '', $hashAlgorithm = '')
    {
        if ($shaOutSign == '') {
            $shaOutSign = $this->settings['postfinance']['shaOut'];
        }
        if ($hashAlgorithm == '') {
            $hashAlgorithm = $this->settings['postfinance']['hashAlgorithm'];
        }

        $status = $this->vars['STATUS'];

        if (!in_array($status, [5, 4, 9, 41, 51, 91])) {
            if ($status == 1) {
                return 'cancel';
            }
            if ($status == 2 || $status == 93) {
                return 'decline';
            }
            if ($status == 52 || $status == 92) {
                return 'exception';
            }
        }

        $hashData = '';

        $shasign = $_REQUEST['SHASIGN'];

        //$this->vars = array_intersect_key($this->vars, array_flip($this->allowedParameters));
        ksort($this->vars);

        foreach ($this->vars as $key => $value) {
            if ($key != 'SHASIGN' && $value!='') {
                $hashData .= $key.'='.$value.$shaOutSign;
            }
        }
        //echo $hashData . '<br>';
        if (strtoupper(hash($hashAlgorithm, $hashData)) != $shasign) {
            return 'exception';
        }

        return 'accept';
    }
}
