<?php

namespace Ig\IgPayment\Utility;

use Ig\IgPayment\Services\PaymentService;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class PaymentUtility implements SingletonInterface {
    protected array $services = [];
    protected ?PaymentService $paymentService = null;
    protected ?string $currency = null;
    protected float $amount =0;
    protected string $checkoutReference = '';

    public function __construct()
    {
        if(is_array($GLOBALS['TYPO3_CONF_VARS']['EXT']['ig_payment']['services'])) {
            foreach($GLOBALS['TYPO3_CONF_VARS']['EXT']['ig_payment']['services'] as $code => $className) {
                if(class_exists($className)) {
                    $this->services[$code] = GeneralUtility::makeInstance($className);
                }
            }
        }
    }
    public function setCurrentService(?string $code, ?string $currency, float $amount, ?string $checkoutReference = null): ?PaymentService
    {
        if ($this->paymentService !== null) {
            if ($this->currency != $currency || '' . $this->amount != '' . $amount || $this->checkoutReference != $checkoutReference || $this->paymentService->getCode() != $code) {
                $this->paymentService->clear($this->checkoutReference);
            }
        }
        $this->currency = $currency;
        $this->amount = $amount;
        $this->checkoutReference = $checkoutReference;// === null ? /* random  */ (string) time() : $checkoutReference;
        $this->paymentService =  $this->getServiceByCode($code);
        //$this->paymentService->setCurrency($currency);
        //$this->paymentService->setAmount($amount);
        //$this->paymentService->setCheckoutReference($checkoutReference);
        return $this->paymentService;
    }
    public function getServiceByCode($code): ?PaymentService
    {
        if(!isset($this->services[$code])) {
            return null;
        }
        return $this->services[$code];
    }

    public function getServices(): array
    {
        return $this->services;
    }
}