<?php
namespace Ig\IgPayment\ViewHelpers\Form;

use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

/**
 * ViewHelper to integrate a payment form using Datatrans.
 */
class DatatransViewHelper extends AbstractTagBasedViewHelper
{

    /**
     *
     * @var string
     */
    const ENDPOINT_URL = 'https://payment.datatrans.biz/upp/jsp/upStart.jsp';

    /**
     *
     * @var string
     */
    const TEST_ENDPOINT_URL = 'https://pilot.datatrans.biz/upp/jsp/upStart.jsp';

    /**
     *
     * @var string
     */
    const TEST_MERCHANT_ID = '1100003257';

    /**
     *
     * @var \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface
     */
    protected $configurationManager;

    /**
     * The settings for the ViewHelper.
     *
     * @var array
     */
    protected $settings = [];

    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager)
    {
        $this->configurationManager = $configurationManager;
    }

    /**
     * Gets the TypoScript settings and prepares and registers the arguments of the ViewHelper.
     */
    public function initializeArguments()
    {
        $typoscript = $this->configurationManager->getConfiguration(\TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
        $settings = $typoscript['plugin.']['tx_igpayment.']['settings.'];
        $this->settings = [
            'datatrans' => $settings['datatrans.']
        ];
        
        $this->registerArgument('url', 'string', 'Datatrans Endpoint Url', false, $this->settings['datatrans']['test'] ? self::TEST_ENDPOINT_URL : self::ENDPOINT_URL);
        $this->registerArgument('merchantId', 'string', 'Datatrans Merchant ID', false, $this->settings['datatrans']['test'] ? self::TEST_MERCHANT_ID : $this->settings['datatrans']['merchantId']);
        $this->registerArgument('language', 'string', 'Datatrans Language', false, $this->settings['datatrans']['language']);
        $this->registerArgument('refno', 'string', 'Reference number for merchant', false, '');
        $this->registerArgument('currency', 'string', 'The used currency', false, 'CHF');
        $this->registerArgument('amount', 'string', 'The amount for the transaction in the smallest unit of the currency', false, null);
        $this->registerArgument('successUrl', 'string', '', false, null);
        $this->registerArgument('errorUrl', 'string', '', false, null);
        $this->registerArgument('cancelUrl', 'string', '', false, null);
    }

    private function checkArgument($argument)
    {
        if (! $this->arguments[$argument]) {
            throw new \InvalidArgumentException('Argument "' . $argument . '" not set in ViewHelper "' . get_class($this) . '"', 1237901529);
        }
    }

    private function checkArguments()
    {
        $this->checkArgument('url');
        $this->checkArgument('merchantId');
        $this->checkArgument('language');
        $this->checkArgument('refno');
        $this->checkArgument('currency');
        $this->checkArgument('amount');
        $this->checkArgument('successUrl');
        $this->checkArgument('errorUrl');
        $this->checkArgument('cancelUrl');
    }

    /**
     * Renders the payment form.
     *
     * @return string
     * @api
     */
    public function render()
    {
        $this->checkArguments();
        
        $output = '
            <form id="payment-form" method="post" action="' . $this->arguments['url'] . '">
			<input type="hidden" name="merchantId" value="' . $this->arguments['merchantId'] . '">
            <input type="hidden" name="language" value="' . $this->arguments['language'] . '">
            <input type="hidden" name="refno"  value="' . $this->arguments['refno'] . '">
            <input type="hidden" name="currency"  value="' . $this->arguments['currency'] . '">
            <input type="hidden" name="amount"  value="' . $this->arguments['amount'] . '">
            <input type="hidden" name="successUrl" value="' . $this->arguments['successUrl'] . '">
            <input type="hidden" name="errorUrl" value="' . $this->arguments['errorUrl'] . '">
            <input type="hidden" name="cancelUrl" value="' . $this->arguments['cancelUrl'] . '">
        ';
        
        $output .= $this->renderChildren();
        $output .= '</form>';
        
        return $output;
    }
}
