<?php
namespace Ig\IgQrcode\Utility;

use TYPO3\CMS\Core\SingletonInterface;

class QrCodeUtility implements SingletonInterface
{
    const PNG = 'PNG';
    const SVG = 'SVG';
    const EPS = 'EPS';
    const PDF = 'PDF';
    
    public static function render(string $content, string $imageType='SVG', array $arguments = [], int $size = 8, string $level = 'L', int $width = null, int $height = null)
    {
        $pipes = [];
        $descriptorspec = [
            0 => ['pipe', 'r'],  // STDIN ist eine Pipe, von der das Child liest
            1 => ['pipe', 'w']
        ];

        $additionalArguments = [];
        $additionalArgumentsString = '';
        if (!empty($arguments)) {
            foreach ($arguments as $name => $value) {
                if (strlen($name) > 1) {
                    $lines = '--';
                    $nameValueSeperator = '=';
                } else {
                    $lines = '-';
                    $nameValueSeperator = ' ';
                }
                $shellValue = ($value !== '' ? $nameValueSeperator .escapeshellarg((string) $value) : '');
                $additionalArguments[] = $lines . $name . $shellValue;
            }
            $additionalArgumentsString = implode(' ',  $additionalArguments);
        }
        
        //echo('qrencode -s 8 --type=' . $imageType . ' ' . $additionalArgumentsString . ' -o -');exit(0);
        if($imageType==self::PDF) {
            $fp=proc_open('qrencode -s ' . $size . ' -l ' . $level . ' --type=EPS ' . $additionalArgumentsString . ' -o - |epstopdf -f -o=- ',  $descriptorspec, $pipes);
        } else {
            $fp=proc_open('qrencode -s ' . $size . ' -l ' . $level . ' --type=' . $imageType . ' ' . $additionalArgumentsString . ' -o -',  $descriptorspec, $pipes);
        }
        fwrite($pipes[0],  $content );
        fclose($pipes[0]);
        $imageContent =  stream_get_contents($pipes[1]);

        if ($imageType === 'SVG' && $width !== null && $height !== null) {
            $imageContent = preg_replace('/<svg([^>]*?)width="[^"]*"/', '<svg$1width="' . $width . '"', $imageContent);
            $imageContent = preg_replace('/<svg([^>]*?)height="[^"]*"/', '<svg$1height="' . $height . '"', (string) $imageContent);
        }
        //die($imageContent);
        return $imageContent;
    }
    
    
}